/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ser;

import java.util.Comparator;
import org.monarchinitiative.phenol.ser.VersionTokenizer;

final class VersionComparator
implements Comparator<String> {
    VersionComparator() {
    }

    @Override
    public int compare(String version1, String version2) {
        VersionTokenizer tokenizer1 = new VersionTokenizer(version1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version2);
        int number1 = 0;
        int number2 = 0;
        String suffix1 = "";
        String suffix2 = "";
        while (tokenizer1.moveNext()) {
            boolean empty2;
            if (!tokenizer2.moveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.moveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.moveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.moveNext());
            return 0;
        }
        return 0;
    }
}

