/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.utils;

import org.slf4j.Logger;

public final class ProgressReporter {
    private final Logger logger;
    private final String elementsLabel;
    private final int totalCount;
    private int stepCount;
    private int current;
    private double startTime;
    private double lastStepTime;

    public ProgressReporter(Logger logger, String elementsLabel, int totalCount) {
        this.logger = logger;
        this.elementsLabel = elementsLabel;
        this.totalCount = totalCount;
        this.current = 0;
        this.stepCount = 0;
    }

    public synchronized void incCurrent() {
        this.setCurrent(this.current + 1);
    }

    public synchronized void setCurrent(int current) {
        int oldCurrent = this.current;
        this.current = current;
        if (100 * oldCurrent / this.totalCount != 100 * current / this.totalCount) {
            this.printProgress();
        }
    }

    public synchronized void printProgress() {
        long now = System.nanoTime();
        double stepElapsedSec = ((double)now - this.lastStepTime) / 1.0E9;
        double elapsedSec = ((double)now - this.startTime) / 1.0E9;
        double elementsPerSec = (double)(this.current - this.stepCount) / stepElapsedSec;
        double estimatedToGoSec = (double)(this.totalCount - this.current) / elementsPerSec;
        this.lastStepTime = now;
        this.stepCount = this.current;
        this.logger.info("Resnik precomputation done by {}% ({} of {} done, step elapsed: {} s, elapsed: {} s, processing {} {}/s, estimated to go: {} s", new Object[]{(int)(100.0 * (double)this.current / (double)this.totalCount), this.current, this.totalCount, stepElapsedSec, elapsedSec, elementsPerSec, this.elementsLabel, estimatedToGoSec});
    }

    public synchronized void start() {
        this.lastStepTime = this.startTime = (double)System.nanoTime();
    }

    public synchronized void stop() {
        if (this.current != this.totalCount) {
            this.current = this.totalCount;
        }
        this.printProgress();
    }
}

