/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.MaskSubgraph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.SimpleGraph;

@Deprecated
public class BlockCutpointGraph<V, E>
extends SimpleGraph<Graph<V, E>, DefaultEdge> {
    private static final long serialVersionUID = -9101341117013163934L;
    private Set<V> cutpoints = new HashSet<V>();
    private Graph<V, DefaultEdge> dfsTree;
    private Graph<V, E> graph;
    private int numOrder;
    private Deque<BCGEdge> stack = new ArrayDeque<BCGEdge>();
    private Map<V, Set<Graph<V, E>>> vertex2biconnectedSubgraphs = new HashMap<V, Set<Graph<V, E>>>();
    private Map<V, Graph<V, E>> vertex2block = new HashMap<V, Graph<V, E>>();
    private Map<V, Integer> vertex2numOrder = new HashMap<V, Integer>();

    public BlockCutpointGraph(Graph<V, E> graph) {
        super(DefaultEdge.class);
        this.graph = GraphTests.requireUndirected(graph, "Graph must be undirected");
        this.dfsTree = new SimpleDirectedGraph(DefaultEdge.class);
        V s = graph.vertexSet().iterator().next();
        this.dfsTree.addVertex(s);
        this.dfsVisit(s, s);
        if (this.dfsTree.edgesOf(s).size() > 1) {
            this.cutpoints.add(s);
        } else {
            this.cutpoints.remove(s);
        }
        for (V cutpoint : this.cutpoints) {
            SimpleGraph<V, E> subgraph = new SimpleGraph<V, E>(this.graph.getEdgeFactory());
            subgraph.addVertex(cutpoint);
            this.vertex2block.put((SimpleGraph<V, E>)cutpoint, (Graph<SimpleGraph<V, E>, E>)subgraph);
            this.addVertex(subgraph);
            Set<Graph<V, E>> biconnectedSubgraphs = this.getBiconnectedSubgraphs(cutpoint);
            for (Graph<V, E> biconnectedSubgraph : biconnectedSubgraphs) {
                assert (this.vertexSet().contains(biconnectedSubgraph));
                this.addEdge(subgraph, biconnectedSubgraph);
            }
        }
    }

    public Graph<V, E> getBlock(V vertex) {
        if (!this.graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.vertex2block.get(vertex);
    }

    public Set<V> getCutpoints() {
        return this.cutpoints;
    }

    public boolean isCutpoint(V vertex) {
        if (!this.graph.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("No such vertex in the graph!");
        }
        return this.cutpoints.contains(vertex);
    }

    private void biconnectedComponentFinished(V s, V n) {
        this.cutpoints.add(s);
        HashSet vertexComponent = new HashSet();
        HashSet<BCGEdge> edgeComponent = new HashSet<BCGEdge>();
        BCGEdge edge = this.stack.removeLast();
        while (this.getNumOrder(edge.getSource()) >= this.getNumOrder(n) && !this.stack.isEmpty()) {
            edgeComponent.add(edge);
            vertexComponent.add(edge.getSource());
            vertexComponent.add(edge.getTarget());
            edge = this.stack.removeLast();
        }
        edgeComponent.add(edge);
        vertexComponent.add(edge.getSource());
        vertexComponent.add(edge.getTarget());
        MaskSubgraph<Object, Object> biconnectedSubgraph = new MaskSubgraph<Object, Object>(this.graph, v -> !vertexComponent.contains(v), e -> false);
        for (Object vertex : vertexComponent) {
            this.vertex2block.put((MaskSubgraph<Object, Object>)vertex, (Graph<MaskSubgraph<Object, Object>, E>)biconnectedSubgraph);
            this.getBiconnectedSubgraphs(vertex).add(biconnectedSubgraph);
        }
        this.addVertex(biconnectedSubgraph);
    }

    private int dfsVisit(V s, V father) {
        ++this.numOrder;
        int minS = this.numOrder;
        this.setNumOrder(s, this.numOrder);
        for (E edge : this.graph.edgesOf(s)) {
            V n = Graphs.getOppositeVertex(this.graph, edge, s);
            if (this.getNumOrder(n) == 0) {
                this.dfsTree.addVertex(n);
                BCGEdge dfsEdge = new BCGEdge(s, n);
                this.dfsTree.addEdge(s, n, dfsEdge);
                this.stack.add(dfsEdge);
                int minN = this.dfsVisit(n, s);
                minS = Math.min(minN, minS);
                if (minN < this.getNumOrder(s)) continue;
                this.biconnectedComponentFinished(s, n);
                continue;
            }
            if (this.getNumOrder(n) >= this.getNumOrder(s) || n.equals(father)) continue;
            BCGEdge backwardEdge = new BCGEdge(s, n);
            this.stack.add(backwardEdge);
            minS = Math.min(this.getNumOrder(n), minS);
        }
        return minS;
    }

    private Set<Graph<V, E>> getBiconnectedSubgraphs(V vertex) {
        return this.vertex2biconnectedSubgraphs.computeIfAbsent((Set)vertex, (Function<Set, Set<Graph<Set, E>>>)((Function<Object, Set>)k -> new HashSet()));
    }

    private int getNumOrder(V vertex) {
        assert (vertex != null);
        return this.vertex2numOrder.getOrDefault(vertex, 0);
    }

    private void setNumOrder(V vertex, int numOrder) {
        this.vertex2numOrder.put((Integer)vertex, numOrder);
    }

    private class BCGEdge
    extends DefaultEdge {
        private static final long serialVersionUID = -5115006161815760059L;
        private V source;
        private V target;

        public BCGEdge(V source, V target) {
            this.source = source;
            this.target = target;
        }

        public V getSource() {
            return this.source;
        }

        public V getTarget() {
            return this.target;
        }
    }
}

