/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.gui.controller;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;
import org.monarchinitiative.hpotextmining.core.miners.TermMiner;
import org.monarchinitiative.hpotextmining.gui.controller.Main;
import org.monarchinitiative.hpotextmining.gui.controller.PopUps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configure {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configure.class);
    private final TermMiner miner;
    private final ExecutorService executorService;
    private final Consumer<Main.Signal> signal;
    private final Set<MinedTerm> terms = new HashSet<MinedTerm>();
    @FXML
    private TextArea contentTextArea;
    @FXML
    private Button analyzeButton;

    Configure(TermMiner miner, ExecutorService executorService, Consumer<Main.Signal> signal) {
        this.miner = miner;
        this.executorService = executorService;
        this.signal = signal;
    }

    Set<MinedTerm> getTerms() {
        return this.terms;
    }

    String getQuery() {
        return this.contentTextArea.getText().replace("-" + System.lineSeparator(), "");
    }

    @FXML
    void analyzeButtonClicked() {
        final String query = this.getQuery();
        Task<Collection<MinedTerm>> task = new Task<Collection<MinedTerm>>(){

            protected Collection<MinedTerm> call() throws Exception {
                return Configure.this.miner.doMining(query);
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$analyzeButtonClicked$0((Task)task, arg_0));
        task.setOnFailed(e -> {
            String msg = e.getSource().getMessage();
            if (e.getSource().getException().getCause() instanceof UnknownHostException) {
                msg = String.format("Unable to connect to %s. Is your internet connection working?", e.getSource().getException().getCause().getMessage());
            }
            PopUps.showThrowableDialog("HPO text mining", "Text mining failed", msg, e.getSource().getException().getCause());
            this.signal.accept(Main.Signal.FAILED);
        });
        task.setOnCancelled(e -> this.signal.accept(Main.Signal.CANCELLED));
        this.executorService.submit((Runnable)task);
    }

    public void initialize() {
    }

    private /* synthetic */ void lambda$analyzeButtonClicked$0(Task task, WorkerStateEvent e) {
        try {
            this.terms.clear();
            this.terms.addAll((Collection)task.get());
            this.signal.accept(Main.Signal.DONE);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOGGER.warn(ex.getMessage());
            this.signal.accept(Main.Signal.FAILED);
        }
    }
}

