/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.gui.controller;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.monarchinitiative.hpotextmining.gui.controller.Main;
import org.monarchinitiative.hpotextmining.gui.controller.WidthAwareTextFields;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermSynonym;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyTree.class);
    private final Ontology ontology;
    private final Consumer<Main.PhenotypeTerm> addHook;
    private Map<String, TermId> labels = new HashMap<String, TermId>();
    @FXML
    private TextField searchTextField;
    @FXML
    private Button goButton;
    @FXML
    private Button addButton;
    @FXML
    private TreeView<Term> ontologyTreeView;
    @FXML
    private WebView infoWebView;
    private WebEngine infoWebEngine;
    @FXML
    private CheckBox notPresentCheckBox;

    public OntologyTree(Ontology ontology, Consumer<Main.PhenotypeTerm> addHook) {
        this.ontology = ontology;
        this.addHook = addHook;
    }

    @FXML
    private void goButtonAction() {
        TermId id = this.labels.get(this.searchTextField.getText());
        if (id != null) {
            this.expandUntilTerm((Term)this.ontology.getTermMap().get(id));
            this.searchTextField.clear();
        }
    }

    @FXML
    private void addButtonAction() {
        TreeItem selected = (TreeItem)this.ontologyTreeView.getSelectionModel().getSelectedItem();
        if (selected != null && this.addHook != null) {
            Main.PhenotypeTerm phenotypeTerm = new Main.PhenotypeTerm((Term)selected.getValue(), !this.notPresentCheckBox.isSelected());
            this.addHook.accept(phenotypeTerm);
        }
        this.notPresentCheckBox.setSelected(false);
    }

    public void initialize() {
        String introHtmlMessage;
        if (this.ontology != null) {
            TermTreeItem root = new TermTreeItem((Term)this.ontology.getTermMap().get(this.ontology.getRootTermId()));
            root.setExpanded(true);
            this.ontologyTreeView.setShowRoot(false);
            this.ontologyTreeView.setRoot((TreeItem)root);
            this.ontologyTreeView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateDescription((TreeItem<Term>)newValue));
            this.ontologyTreeView.setCellFactory((Callback)new Callback<TreeView<Term>, TreeCell<Term>>(){

                public TreeCell<Term> call(TreeView<Term> param) {
                    return new TreeCell<Term>(){

                        public void updateItem(Term term, boolean empty) {
                            super.updateItem((Object)term, empty);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(term.getName());
                            }
                        }
                    };
                }
            });
            this.ontology.getTermMap().values().forEach(term -> this.labels.putIfAbsent(term.getName(), term.getId()));
            WidthAwareTextFields.bindWidthAwareAutoCompletion(this.searchTextField, this.labels.keySet());
            introHtmlMessage = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>HPO tree browser</title></head><body><p>Click on HPO term in the tree browser to display additional information</p></body></html>";
        } else {
            this.goButton.setDisable(true);
            this.searchTextField.setDisable(true);
            this.ontologyTreeView.setDisable(true);
            this.notPresentCheckBox.setDisable(true);
            this.addButton.setDisable(true);
            introHtmlMessage = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>HPO tree browser</title></head><body><p>Ontology is not available so the functions are disabled.</p></body></html>";
        }
        this.infoWebEngine = this.infoWebView.getEngine();
        this.infoWebEngine.loadContent(introHtmlMessage);
    }

    void focusOnTerm(Term term) {
        this.expandUntilTerm(term);
    }

    private void expandUntilTerm(Term term) {
        if (OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)term.getId(), (TermId)this.ontology.getRootTermId())) {
            Stack<Object> termStack = new Stack<Object>();
            termStack.add(term);
            Set parents = this.ontology.getParentTermIds(term.getId());
            while (parents.size() != 0) {
                TermId parent = (TermId)parents.iterator().next();
                termStack.add(this.ontology.getTermMap().get(parent));
                parents = this.ontology.getParentTermIds(parent);
            }
            ObservableList children = this.ontologyTreeView.getRoot().getChildren();
            termStack.pop();
            TreeItem target = this.ontologyTreeView.getRoot();
            block1: while (!termStack.empty()) {
                Term current = (Term)termStack.pop();
                for (TreeItem child : children) {
                    if (!((Term)child.getValue()).equals((Object)current)) continue;
                    child.setExpanded(true);
                    target = child;
                    children = child.getChildren();
                    continue block1;
                }
            }
            this.ontologyTreeView.getSelectionModel().select((Object)target);
            this.ontologyTreeView.scrollTo(this.ontologyTreeView.getSelectionModel().getSelectedIndex());
        } else {
            LOGGER.warn("Unable to find the path from {} to {}", (Object)this.ontology.getRootTermId(), (Object)term.getId());
        }
    }

    TermTreeItem getSelectedTerm() {
        return this.ontologyTreeView.getSelectionModel().getSelectedItem() == null ? null : (TermTreeItem)((Object)this.ontologyTreeView.getSelectionModel().getSelectedItem());
    }

    private void updateDescription(TreeItem<Term> treeItem) {
        if (treeItem == null) {
            return;
        }
        Term term = (Term)treeItem.getValue();
        String HTML_TEMPLATE = "<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>HPO tree browser</title></head><body><p><b>Term ID:</b> %s</p><p><b>Term Name:</b> %s</p><p><b>Synonyms:</b> %s</p><p><b>Definition:</b> %s</p></body></html>";
        String termID = term.getId().getValue();
        String synonyms = term.getSynonyms() == null ? "" : term.getSynonyms().stream().map(TermSynonym::getValue).collect(Collectors.joining(", "));
        String definition = term.getDefinition() == null ? "" : term.getDefinition();
        String content = String.format(HTML_TEMPLATE, termID, term.getName(), synonyms, definition);
        this.infoWebEngine.loadContent(content);
    }

    public StringProperty observableSearchText() {
        return this.searchTextField.textProperty();
    }

    class TermTreeItem
    extends TreeItem<Term> {
        private ObservableList<TreeItem<Term>> childrenList;

        TermTreeItem(Term term) {
            super((Object)term);
        }

        public boolean isLeaf() {
            return OntologyAlgorithm.getChildTerms((Ontology)OntologyTree.this.ontology, (TermId)((Term)this.getValue()).getId(), (boolean)false).size() == 0;
        }

        public ObservableList<TreeItem<Term>> getChildren() {
            if (this.childrenList == null) {
                LOGGER.debug(String.format("Getting children for term %s", ((Term)this.getValue()).getName()));
                this.childrenList = FXCollections.observableArrayList();
                Set children = OntologyAlgorithm.getChildTerms((Ontology)OntologyTree.this.ontology, (TermId)((Term)this.getValue()).getId(), (boolean)false).stream().map(OntologyTree.this.ontology.getTermMap()::get).collect(Collectors.toSet());
                children.stream().sorted(Comparator.comparing(Term::getName)).map(x$0 -> new TermTreeItem((Term)x$0)).forEach(arg_0 -> this.childrenList.add(arg_0));
                super.getChildren().setAll(this.childrenList);
            }
            return super.getChildren();
        }
    }
}

