/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.io;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixHelper {
    private static final Logger logger = LoggerFactory.getLogger(PrefixHelper.class);
    private static String defaultContextPath = "/obo_context.jsonld";
    private Context context = new Context();

    public PrefixHelper() {
        try {
            this.setContext(this.getDefaultContext());
        }
        catch (IOException e) {
            logger.warn("Could not load default prefixes.");
            logger.warn(e.getMessage());
        }
    }

    public PrefixHelper(boolean defaults) {
        try {
            if (defaults) {
                this.setContext(this.getDefaultContext());
            } else {
                this.setContext();
            }
        }
        catch (IOException e) {
            logger.warn("Could not load default prefixes.");
            logger.warn(e.getMessage());
        }
    }

    public PrefixHelper(Map<String, Object> map) {
        this.setContext(map);
    }

    public PrefixHelper(String path) {
        try {
            String jsonString = FileUtils.readFileToString((File)new File(path));
            this.setContext(jsonString);
        }
        catch (IOException e) {
            logger.warn("Could not load prefixes from " + path);
            logger.warn(e.getMessage());
        }
    }

    public PrefixHelper(File file) {
        try {
            String jsonString = FileUtils.readFileToString((File)file);
            this.setContext(jsonString);
        }
        catch (IOException e) {
            logger.warn("Could not load prefixes from " + file);
            logger.warn(e.getMessage());
        }
    }

    public File guessCatalogFile(File ontologyFile) {
        String path = ontologyFile.getParent();
        String catalogPath = "catalog-v001.xml";
        if (path != null) {
            catalogPath = path + "/catalog-v001.xml";
        }
        return new File(catalogPath);
    }

    public IRI createIRI(String term) {
        if (term == null) {
            return null;
        }
        try {
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            jsonMap.put(term, "ignore this string");
            Object expanded = new JsonLdApi().expand(this.context, jsonMap);
            String result = (String)((Map)expanded).keySet().iterator().next();
            if (result != null) {
                return IRI.create((String)result);
            }
        }
        catch (Exception e) {
            logger.warn("Could not create IRI for {}", (Object)term);
            logger.warn(e.getMessage());
        }
        return null;
    }

    public static Context parseContext(String jsonString) throws IOException {
        try {
            Object jsonObject = JsonUtils.fromString((String)jsonString);
            if (!(jsonObject instanceof Map)) {
                return null;
            }
            Map jsonMap = (Map)jsonObject;
            if (!jsonMap.containsKey("@context")) {
                return null;
            }
            Object jsonContext = jsonMap.get("@context");
            return new Context().parse(jsonContext);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Context getDefaultContext() throws IOException {
        InputStream stream = PrefixHelper.class.getResourceAsStream(defaultContextPath);
        String jsonString = IOUtils.toString((InputStream)stream);
        return PrefixHelper.parseContext(jsonString);
    }

    public Context getContext() {
        return this.context.clone();
    }

    public void setContext() {
        this.context = new Context();
    }

    public void setContext(Context context) {
        if (context == null) {
            this.setContext();
        } else {
            this.context = context;
        }
    }

    public void setContext(String jsonString) {
        try {
            this.context = PrefixHelper.parseContext(jsonString);
        }
        catch (Exception e) {
            logger.warn("Could not set context from JSON");
            logger.warn(e.getMessage());
        }
    }

    public void setContext(Map<String, Object> map) {
        try {
            this.context = new Context().parse(map);
        }
        catch (Exception e) {
            logger.warn("Could not set context {}", map);
            logger.warn(e.getMessage());
        }
    }

    public static DefaultPrefixManager makePrefixManager(Map<String, String> prefixes) {
        DefaultPrefixManager pm = new DefaultPrefixManager();
        for (Map.Entry<String, String> entry : prefixes.entrySet()) {
            pm.setPrefix(entry.getKey() + ":", entry.getValue());
        }
        return pm;
    }

    public DefaultPrefixManager getPrefixManager() {
        return PrefixHelper.makePrefixManager(this.context.getPrefixes(false));
    }

    public void addPrefix(String combined) throws IllegalArgumentException {
        String[] results = combined.split(":", 2);
        if (results.length < 2) {
            throw new IllegalArgumentException("Invalid prefix string: " + combined);
        }
        this.addPrefix(results[0], results[1]);
    }

    public void addPrefix(String prefix, String target) {
        try {
            this.context.put((Object)prefix.trim(), (Object)target.trim());
            this.context.remove((Object)"@base");
            this.setContext((Map<String, Object>)this.context);
        }
        catch (Exception e) {
            logger.warn("Could not load add prefix \"{}\" \"{}\"", (Object)prefix, (Object)target);
            logger.warn(e.getMessage());
        }
    }

    public Map<String, String> getPrefixes() {
        return this.context.getPrefixes(false);
    }

    public void setPrefixes(Map<String, Object> map) {
        this.setContext(map);
    }

    public String getContextString() throws IOException {
        try {
            Map compact = JsonLdProcessor.compact((Object)JsonUtils.fromString((String)"{}"), (Object)this.context.getPrefixes(false), (JsonLdOptions)new JsonLdOptions());
            return JsonUtils.toPrettyString((Object)compact);
        }
        catch (Exception e) {
            throw new IOException("JSON-LD could not be generated", e);
        }
    }

    public void saveContext(String path) throws IOException {
        this.saveContext(new File(path));
    }

    public void saveContext(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(this.getContextString());
        writer.close();
    }
}

