/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.NodeOrEdge;

public class Edge
implements NodeOrEdge {
    private final String sub;
    private final String pred;
    private final String obj;
    private final Meta meta;

    private Edge(Builder builder) {
        this.sub = builder.sub;
        this.pred = builder.pred;
        this.obj = builder.obj;
        this.meta = builder.meta;
    }

    public String getSub() {
        return this.sub;
    }

    public String getPred() {
        return this.pred;
    }

    public String getObj() {
        return this.obj;
    }

    @Override
    public Meta getMeta() {
        return this.meta;
    }

    public static class Builder {
        @JsonProperty
        private String sub;
        @JsonProperty
        private String pred;
        @JsonProperty
        private String obj;
        @JsonProperty
        private Meta meta;

        public Builder sub(String subj) {
            this.sub = subj;
            return this;
        }

        public Builder obj(String obj) {
            this.obj = obj;
            return this;
        }

        public Builder pred(String pred) {
            this.pred = pred;
            return this;
        }

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Edge build() {
            return new Edge(this);
        }
    }
}

