/*
 * Decompiled with CFR 0.152.
 */
package ioinformarics.oss.jackson.module.jsonld;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldLink;
import ioinformarics.oss.jackson.module.jsonld.annotation.JsonldProperty;
import java.util.Arrays;
import java.util.Optional;

public class JsonldContextFactory {
    public static Optional<ObjectNode> fromAnnotations(Object instance) {
        return JsonldContextFactory.fromAnnotations(instance.getClass());
    }

    public static Optional<ObjectNode> fromAnnotations(Iterable<?> instances) {
        ObjectNode mergedContext = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
        instances.forEach(e -> JsonldContextFactory.fromAnnotations(e).map(it -> mergedContext.setAll(it)));
        return mergedContext.size() != 0 ? Optional.of(mergedContext) : Optional.empty();
    }

    public static Optional<ObjectNode> fromAnnotations(Class<?> objType) {
        ObjectNode generatedContext = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
        Arrays.asList(objType.getDeclaredFields()).forEach(field -> {
            JsonldProperty jsonldProperty = field.getAnnotation(JsonldProperty.class);
            if (jsonldProperty != null) {
                generatedContext.set(field.getName(), (JsonNode)TextNode.valueOf((String)jsonldProperty.value()));
            }
        });
        JsonldLink[] links = (JsonldLink[])objType.getAnnotationsByType(JsonldLink.class);
        if (links != null) {
            for (int i = 0; i < links.length; ++i) {
                ObjectNode linkNode = JsonNodeFactory.withExactBigDecimals((boolean)true).objectNode();
                linkNode.set("@id", (JsonNode)new TextNode(links[i].rel()));
                linkNode.set("@type", (JsonNode)new TextNode("@id"));
                generatedContext.set(links[i].name(), (JsonNode)linkNode);
            }
        }
        return generatedContext.size() != 0 ? Optional.of(generatedContext) : Optional.empty();
    }

    public static Optional<JsonNode> multiContext(Optional<String> externalContext, Optional<ObjectNode> internalContext) {
        if (internalContext.isPresent()) {
            return externalContext.isPresent() ? Optional.of(JsonldContextFactory.buildMultiContext(externalContext.get(), (JsonNode)internalContext.get())) : internalContext.map(it -> it);
        }
        return externalContext.map(it -> TextNode.valueOf((String)it));
    }

    private static ArrayNode buildMultiContext(String context, JsonNode generatedContext) {
        return JsonNodeFactory.withExactBigDecimals((boolean)true).arrayNode().add(context).add(generatedContext);
    }
}

