/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.annotations.hpo;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.base.HpoAnnotationModelException;
import org.monarchinitiative.phenol.io.annotations.hpo.HpoAnnotationFileParser;
import org.monarchinitiative.phenol.ontology.data.Ontology;

public class HpoAnnotationFileIngestor {
    private final Ontology ontology;
    private final List<String> v2smallFilePaths;
    private final List<HpoAnnotationModel> v2SmallFileList = new ArrayList<HpoAnnotationModel>();
    private final Set<String> omitEntries;
    private int n_total_annotation_lines = 0;
    private int n_total_omitted_entries = 0;
    private boolean mergeEntries = false;
    private final List<String> errors = new ArrayList<String>();

    public List<HpoAnnotationModel> getV2SmallFileEntries() {
        return this.v2SmallFileList;
    }

    public HpoAnnotationFileIngestor(String directoryPath, String omitFile, Ontology ontology) {
        this(directoryPath, omitFile, ontology, false);
    }

    public HpoAnnotationFileIngestor(String directoryPath, String omitFile, Ontology ontology, boolean merge) {
        this.omitEntries = this.getOmitEntries(omitFile);
        this.mergeEntries = merge;
        this.v2smallFilePaths = this.getListOfV2SmallFiles(directoryPath);
        this.ontology = ontology;
        this.inputHpoAnnotationFiles();
    }

    private void inputHpoAnnotationFiles() {
        boolean i = false;
        for (String path : this.v2smallFilePaths) {
            HpoAnnotationFileParser parser = new HpoAnnotationFileParser(path, this.ontology);
            try {
                HpoAnnotationModel v2sf = parser.parse();
                if (this.mergeEntries) {
                    v2sf = v2sf.getMergedModel();
                }
                this.n_total_annotation_lines += v2sf.getNumberOfAnnotations();
                this.v2SmallFileList.add(v2sf);
            }
            catch (HpoAnnotationModelException hafe) {
                System.err.println(String.format("Errors encountered with V2 small file at %s: {%s", path, hafe.getMessage()));
            }
        }
    }

    private Set<String> getOmitEntries(String path) {
        if (path == null || path.isEmpty()) {
            return ImmutableSet.of();
        }
        HashSet<String> entrylist = new HashSet<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] A = line.split("\\s+");
                String id = A[0];
                entrylist.add(id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errors.add(e.getMessage());
        }
        return entrylist;
    }

    private String baseName(Path path) {
        String bname = path.getFileName().toString();
        bname = bname.replace('-', ':').replace(".tab", "");
        return bname;
    }

    private List<String> getListOfV2SmallFiles(String v2smallFileDirectory) {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(v2smallFileDirectory, new String[0]));){
            for (Path path : directoryStream) {
                if (!path.toString().endsWith(".tab")) continue;
                String basename = this.baseName(path);
                if (this.omitEntries.contains(basename)) {
                    ++this.n_total_omitted_entries;
                    continue;
                }
                fileNames.add(path.toString());
            }
        }
        catch (IOException ex) {
            this.errors.add(String.format("Could not get list of small v2smallFilePaths from %s [%s]. Terminating...", v2smallFileDirectory, ex));
        }
        return fileNames;
    }
}

