/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.geneontology.obographs.model.GraphDocument;
import org.geneontology.obographs.owlapi.FromOwl;
import org.monarchinitiative.phenol.base.PhenolException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OboGraphDocumentLoader {
    private OboGraphDocumentLoader() {
    }

    public static GraphDocument loadOwl(Path path) throws IOException, PhenolException {
        return OboGraphDocumentLoader.loadObo(Files.newInputStream(path, new OpenOption[0]));
    }

    public static GraphDocument loadOwl(InputStream inputStream) throws PhenolException {
        return OboGraphDocumentLoader.loadObo(inputStream);
    }

    public static GraphDocument loadObo(Path path) throws IOException, PhenolException {
        return OboGraphDocumentLoader.loadObo(Files.newInputStream(path, new OpenOption[0]));
    }

    public static GraphDocument loadObo(InputStream inputStream) throws PhenolException {
        OWLOntology owlOntology;
        OWLOntologyManager m = OWLManager.createOWLOntologyManager();
        try {
            owlOntology = m.loadOntologyFromOntologyDocument(inputStream);
        }
        catch (OWLOntologyCreationException e) {
            throw new PhenolException((Throwable)e);
        }
        FromOwl fromOwl = new FromOwl();
        return fromOwl.generateGraphDocument(owlOntology);
    }

    public static GraphDocument loadJson(Path path) throws IOException {
        return OboGraphDocumentLoader.loadJson(Files.newInputStream(path, new OpenOption[0]));
    }

    public static GraphDocument loadJson(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (GraphDocument)objectMapper.readValue(inputStream, GraphDocument.class);
    }
}

