/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo.hpo;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoAnnotationLine {
    private static final int DATABASE_ID_IDX = 0;
    private static final int DB_NAME_IDX = 1;
    private static final int QUALIFIER_IDX = 2;
    private static final int PHENOTYPE_ID_IDX = 3;
    private static final int DB_REFERENCE_IDX = 4;
    private static final int EVIDENCE_IDX = 5;
    private static final int ONSET_ID_IDX = 6;
    private static final int FREQUENCY_IDX = 7;
    private static final int SEX_IDX = 8;
    private static final int MODIFIER_IDX = 9;
    private static final int ASPECT_IDX = 10;
    private static final int BIOCURATION_IDX = 11;
    private static final String DEFAULT_FREQUENCY_STRING = "n/a";
    private static final String EMPTY_STRING = "";
    private boolean valid_number_of_fields = true;
    private static final String[] headerFields = new String[]{"DatabaseID", "DiseaseName", "Qualifier", "HPO_ID", "Reference", "Evidence", "Onset", "Frequency", "Sex", "Modifier", "Aspect", "Biocuration"};
    private String databaseId;
    private String DbObjectName;
    private boolean NOT;
    private TermId phenotypeId;
    private String publication;
    private String evidence;
    private TermId onsetId = null;
    private String frequency;
    private String sex;
    private String modifierList;
    private String aspect;
    private String biocuration;

    private HpoAnnotationLine(String line) throws PhenolException {
        String[] fields = line.split("\t");
        if (fields.length != headerFields.length) {
            this.valid_number_of_fields = false;
            throw new PhenolException("[phenol:ERROR] Annotation line with " + fields.length + "fields: \"" + line + "\"");
        }
        this.databaseId = fields[0];
        this.DbObjectName = fields[1];
        String phenoId = fields[3];
        this.phenotypeId = TermId.of((String)phenoId);
        String onset = fields[6];
        if (onset != null && onset.startsWith("HP:")) {
            this.onsetId = TermId.of((String)onset);
        }
        this.frequency = fields[7];
        this.sex = fields[8];
        String neg = fields[2];
        this.NOT = neg != null && neg.equalsIgnoreCase("NOT");
        this.aspect = fields[10];
        this.modifierList = fields[9];
        this.publication = fields[4];
        this.evidence = fields[5];
        this.biocuration = fields[11];
    }

    static HpoAnnotationLine constructFromString(String line) throws PhenolException {
        try {
            return new HpoAnnotationLine(line);
        }
        catch (PhenolException e) {
            throw new PhenolException(String.format("Exception [%s] parsing line: %s", e.getMessage(), line));
        }
    }

    static boolean isValidHeaderLine(String line) throws PhenolException {
        String[] fields = line.split("\t");
        if (fields.length != headerFields.length) {
            String msg = String.format("Expected %d fields in header line but got %d", headerFields.length, fields.length);
            throw new PhenolException(msg);
        }
        for (int i = 0; i < headerFields.length; ++i) {
            if (fields[i].equals(headerFields[i])) continue;
            String msg = String.format("Expected header field %d to be %s but got %s", i, headerFields[i], fields[i]);
            throw new PhenolException(msg);
        }
        return true;
    }

    final String getDiseaseId() {
        return this.databaseId;
    }

    TermId getDiseaseTermId() throws PhenolException {
        if (this.databaseId.startsWith("OMIM") || this.databaseId.startsWith("ORPHA") || this.databaseId.startsWith("DECIPHER")) {
            return TermId.of((String)this.databaseId);
        }
        throw new PhenolException("Invalid disease id (not OMIM/ORPHA/DECIPHER: " + this.databaseId);
    }

    TermId getPhenotypeId() {
        return this.phenotypeId;
    }

    TermId getOnsetId() {
        return this.onsetId;
    }

    String getFrequency() {
        return this.frequency;
    }

    String getSex() {
        return this.sex;
    }

    private String getModifierList() {
        return this.modifierList;
    }

    List<String> getPublication() {
        String[] A;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (this.publication == null || this.publication.isEmpty()) {
            return builder.build();
        }
        for (String a : A = this.publication.split(";")) {
            builder.add((Object)a.trim());
        }
        return builder.build();
    }

    String getEvidence() {
        return this.evidence;
    }

    String getBiocuration() {
        return this.biocuration;
    }

    String getDbObjectName() {
        return this.DbObjectName;
    }

    String getAspect() {
        return this.aspect;
    }

    boolean isNOT() {
        return this.NOT;
    }

    boolean hasValidNumberOfFields() {
        return this.valid_number_of_fields;
    }

    static HpoAnnotation toHpoAnnotation(HpoAnnotationLine line, Ontology ontology) {
        TermId phenoId = line.getPhenotypeId();
        double frequency = HpoAnnotationLine.getFrequency(line.getFrequency(), ontology);
        String frequencyString = line.frequency.isEmpty() ? DEFAULT_FREQUENCY_STRING : line.frequency;
        HpoOnset onset = HpoAnnotationLine.getOnset(line.onsetId);
        return new HpoAnnotation(phenoId, frequency, frequencyString, onset, HpoAnnotationLine.getModifiers(line.getModifierList()), line.getPublication());
    }

    private static List<TermId> getModifiers(String lst) {
        String[] modifierTermStrings;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (lst == null || lst.isEmpty()) {
            return builder.build();
        }
        for (String mt : modifierTermStrings = lst.split(";")) {
            TermId mtId = TermId.of((String)mt.trim());
            builder.add((Object)mtId);
        }
        return builder.build();
    }

    private static double getFrequency(String freq, Ontology ontology) {
        if (freq == null || freq.isEmpty()) {
            return HpoFrequency.ALWAYS_PRESENT.mean();
        }
        int i = freq.indexOf(37);
        if (i > 0) {
            return 0.01 * Double.parseDouble(freq.substring(0, i));
        }
        i = freq.indexOf(47);
        if (i > 0 && freq.length() > i + 1) {
            int n = Integer.parseInt(freq.substring(0, i));
            int m = Integer.parseInt(freq.substring(i + 1));
            return (double)n / (double)m;
        }
        try {
            TermId tid = HpoAnnotationLine.string2TermId(freq, ontology);
            if (tid != null) {
                return HpoFrequency.fromTermId((TermId)tid).mean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HpoFrequency.ALWAYS_PRESENT.mean();
    }

    private static TermId string2TermId(String hp, Ontology ontology) {
        if (!hp.startsWith("HP:")) {
            return null;
        }
        TermId tid = TermId.of((String)hp);
        if (ontology.getTermMap().containsKey(tid)) {
            return ((Term)ontology.getTermMap().get(tid)).getId();
        }
        return null;
    }

    private static HpoOnset getOnset(TermId ons) {
        if (ons == null) {
            return HpoOnset.UNKNOWN;
        }
        return HpoOnset.fromTermId((TermId)ons);
    }

    public String toString() {
        CharSequence[] fields = new String[]{this.databaseId, this.DbObjectName, this.phenotypeId.getValue(), this.onsetId == null ? EMPTY_STRING : this.onsetId.getValue(), this.frequency, this.sex, this.NOT ? "NOT" : EMPTY_STRING, this.aspect, this.modifierList, this.publication, this.evidence, this.biocuration};
        return String.join((CharSequence)"\t", fields);
    }
}

