/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo.mpo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.formats.mpo.MpAllelicComposition;
import org.monarchinitiative.phenol.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.formats.mpo.MpSex;
import org.monarchinitiative.phenol.formats.mpo.MpSimpleModel;
import org.monarchinitiative.phenol.formats.mpo.MpStrain;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpAnnotationParser {
    private final String genePhenoPath;
    private final InputStream genePhenoInputstream;
    private final String phenoSexPath;
    private final InputStream phenoSexInputstream;
    private Map<TermId, Map<TermId, MpAnnotation>> geno2ssannotMap = ImmutableMap.of();
    private Map<TermId, MpSimpleModel> genotypeAccessionToMpModelMap;
    private boolean verbose = true;
    private List<String> parseErrors;

    public MpAnnotationParser(String path) throws PhenolException {
        this.genePhenoPath = path;
        this.phenoSexPath = null;
        this.phenoSexInputstream = null;
        this.parseErrors = new ArrayList<String>();
        try {
            this.genePhenoInputstream = new FileInputStream(this.genePhenoPath);
            this.parse();
        }
        catch (IOException e) {
            throw new PhenolException("Could not parse MGI_GenePheno.rpt: " + e.getMessage());
        }
    }

    public MpAnnotationParser(InputStream is) throws PhenolException {
        this.genePhenoPath = "n/a";
        this.phenoSexPath = "n/a";
        this.genePhenoInputstream = is;
        this.phenoSexInputstream = null;
        this.parseErrors = new ArrayList<String>();
        try {
            System.err.println("PARSE SIMPLE");
            this.parse();
        }
        catch (IOException e) {
            throw new PhenolException("Could not parse MGI_GenePheno.rpt: " + e.getMessage());
        }
    }

    public MpAnnotationParser(String genePhenoPath, String phenoSexPath) throws PhenolException {
        this.genePhenoPath = genePhenoPath;
        this.phenoSexPath = phenoSexPath;
        this.parseErrors = new ArrayList<String>();
        try {
            this.genePhenoInputstream = new FileInputStream(this.genePhenoPath);
            this.phenoSexInputstream = new FileInputStream(this.phenoSexPath);
            this.parsePhenoSexData();
            this.parse();
        }
        catch (IOException e) {
            throw new PhenolException("Could not parse MGI_GenePheno.rpt: " + e.getMessage());
        }
    }

    public Map<TermId, MpSimpleModel> getGenotypeAccessionToMpModelMap() {
        return this.genotypeAccessionToMpModelMap;
    }

    private void parsePhenoSexData() throws IOException, PhenolException {
        int EXPECTED_NUMBER_SEXSPECIFIC_FIELDS = 7;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.phenoSexInputstream));
        this.geno2ssannotMap = new HashMap<TermId, Map<TermId, MpAnnotation>>();
        String line = br.readLine();
        if (!line.startsWith("Genotype ID")) {
            throw new PhenolException("Malformed header of MGI_Pheno_Sex.rpt: " + line);
        }
        while ((line = br.readLine()) != null) {
            String[] A = line.split("\t");
            if (A.length < EXPECTED_NUMBER_SEXSPECIFIC_FIELDS) {
                if (!this.verbose) continue;
                System.err.println("[Phenol-ERROR] Unexpected number of fields in MGI_Pheno_Sex.rpt(" + A.length + ") in line " + line);
                continue;
            }
            SexSpecificAnnotationLine ssaline = new SexSpecificAnnotationLine(A);
            TermId genotypeId = ssaline.genotypeID;
            MpAnnotation annot = ssaline.toMpAnnotation();
            this.geno2ssannotMap.putIfAbsent(genotypeId, new HashMap());
            Map<TermId, MpAnnotation> annotset = this.geno2ssannotMap.get(genotypeId);
            if (annotset.containsKey(annot.getTermId())) {
                MpAnnotation previousannot = annotset.get(annot.getTermId());
                MpAnnotation mergedannot = MpAnnotation.merge((MpAnnotation)previousannot, (MpAnnotation)annot);
                annotset.put(mergedannot.getTermId(), mergedannot);
                continue;
            }
            annotset.put(annot.getTermId(), annot);
        }
    }

    private void parse() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.genePhenoInputstream));
        ArrayListMultimap annotationCollector = ArrayListMultimap.create();
        while ((line = br.readLine()) != null) {
            int EXPECTED_NUMBER_OF_FIELDS;
            String[] A = line.split("\t");
            if (A.length < (EXPECTED_NUMBER_OF_FIELDS = 8)) {
                if (!this.verbose) continue;
                System.err.println("[Phenol-ERROR] Unexpected number of fields in MGI_GenePheno.rpt (" + A.length + ") in line " + line);
                continue;
            }
            try {
                AnnotationLine annot = new AnnotationLine(A);
                TermId modelId = annot.getGenotypeAccessionId();
                annotationCollector.put((Object)modelId, (Object)annot);
            }
            catch (PhenolException e) {
                String err = String.format("[PARSE ERROR] %s (%s)", e.getMessage(), line);
                this.parseErrors.add(err);
            }
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (TermId genoId : annotationCollector.keySet()) {
            Collection annotationLines = annotationCollector.get((Object)genoId);
            ImmutableList.Builder annotbuilder = new ImmutableList.Builder();
            Iterator it = annotationLines.iterator();
            MpStrain background = null;
            MpAllelicComposition allelicComp = null;
            TermId alleleId = null;
            String alleleSymbol = null;
            TermId markerId = null;
            ImmutableMap sexSpecific = ImmutableMap.of();
            if (this.geno2ssannotMap.containsKey(genoId)) {
                ImmutableMap.Builder imapbuilder = new ImmutableMap.Builder();
                Map<TermId, MpAnnotation> annots = this.geno2ssannotMap.get(genoId);
                for (MpAnnotation mpann : annots.values()) {
                    imapbuilder.put((Object)mpann.getTermId(), (Object)mpann);
                }
                try {
                    sexSpecific = imapbuilder.build();
                }
                catch (Exception e) {
                    System.err.println("Error building map of sexSpecific-specific annotations for " + genoId.getValue() + ": " + e.getMessage());
                }
            }
            while (it.hasNext()) {
                AnnotationLine aline = (AnnotationLine)it.next();
                MpAnnotation annot = aline.toMpAnnotation();
                TermId mpoId = aline.getMpId();
                background = aline.geneticBackground;
                allelicComp = aline.getAllelicComp();
                alleleId = aline.getAlleleId();
                alleleSymbol = aline.getAlleleSymbol();
                markerId = aline.getMarkerAccessionId();
                annotbuilder.add((Object)sexSpecific.getOrDefault(mpoId, annot));
            }
            MpSimpleModel mod = new MpSimpleModel(genoId, background, allelicComp, alleleId, alleleSymbol, markerId, (List)annotbuilder.build());
            builder.put((Object)genoId, (Object)mod);
        }
        this.genotypeAccessionToMpModelMap = builder.build();
    }

    public boolean hasParseError() {
        return this.parseErrors.size() > 0;
    }

    public List<String> getParseErrors() {
        return this.parseErrors;
    }

    private static class SexSpecificAnnotationLine {
        private final TermId genotypeID;
        private final MpSex sex;
        private final TermId mpId;
        private final MpAllelicComposition allelicComposition;
        private final MpStrain strain;
        private final boolean sexSpecificNormal;
        private final Set<String> pmidList;

        SexSpecificAnnotationLine(String[] A) throws PhenolException {
            String[] B;
            this.genotypeID = TermId.of((String)A[0]);
            this.sex = MpSex.fromString((String)A[1]);
            this.mpId = TermId.of((String)A[2]);
            this.allelicComposition = MpAllelicComposition.fromString((String)A[3]);
            this.strain = MpStrain.fromString((String)A[4]);
            this.sexSpecificNormal = A[5].equals("Y");
            String pmids = A[6];
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (String b : B = pmids.split(Pattern.quote("|"))) {
                builder.add((Object)b);
            }
            this.pmidList = builder.build();
        }

        public MpAnnotation toMpAnnotation() {
            if (this.sexSpecificNormal) {
                MpAnnotation.Builder builder = new MpAnnotation.Builder(this.mpId, this.pmidList).sexSpecificNormal(this.sex);
                return builder.build();
            }
            MpAnnotation.Builder builder = new MpAnnotation.Builder(this.mpId, this.pmidList).sexSpecific(this.sex);
            return builder.build();
        }
    }

    private static class AnnotationLine {
        private final int ALLELIC_COMPOSITION_IDX = 0;
        private final int ALLELE_SYMBOL_IDX = 1;
        private final int ALLELE_ID_IDX = 2;
        private final int GENETIC_BACKGROUND_IDX = 3;
        private final int MPO_IDX = 4;
        private final int PUBMED_IDX = 5;
        private final int MGI_MARKER_IDX = 6;
        private final int GENOTYPE_ACCESSION_IDX = 7;
        private final MpAllelicComposition allelicComp;
        private final String alleleSymbol;
        private final TermId alleleId;
        private final MpStrain geneticBackground;
        private final TermId mpId;
        private final Set<String> pmidSet;
        private final TermId markerAccessionId;
        private final TermId genotypeAccessionId;

        AnnotationLine(String[] annotations) throws PhenolException {
            String[] pubMedIds;
            this.allelicComp = MpAllelicComposition.fromString((String)annotations[0]);
            this.alleleSymbol = annotations[1];
            this.alleleId = this.parseOrThrowException(annotations[2]);
            this.geneticBackground = MpStrain.fromString((String)annotations[3]);
            this.mpId = this.parseOrThrowException(annotations[4]);
            String pmids = annotations[5];
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (String b : pubMedIds = pmids.split(Pattern.quote("|"))) {
                builder.add((Object)b);
            }
            this.pmidSet = builder.build();
            this.markerAccessionId = this.parseOrThrowException(annotations[6]);
            this.genotypeAccessionId = this.parseOrThrowException(annotations[7]);
        }

        private TermId parseOrThrowException(String termId) throws PhenolException {
            try {
                return TermId.of((String)termId);
            }
            catch (PhenolRuntimeException e) {
                throw new PhenolException(e.getMessage());
            }
        }

        public MpAllelicComposition getAllelicComp() {
            return this.allelicComp;
        }

        public String getAlleleSymbol() {
            return this.alleleSymbol;
        }

        public TermId getAlleleId() {
            return this.alleleId;
        }

        public MpStrain getGeneticBackground() {
            return this.geneticBackground;
        }

        public TermId getMpId() {
            return this.mpId;
        }

        public Set<String> getPmidSet() {
            return this.pmidSet;
        }

        public TermId getMarkerAccessionId() {
            return this.markerAccessionId;
        }

        public TermId getGenotypeAccessionId() {
            return this.genotypeAccessionId;
        }

        public MpAnnotation toMpAnnotation() {
            return new MpAnnotation.Builder(this.mpId, this.pmidSet).build();
        }
    }
}

