/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.protobuf.PackageVersion;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufGenerator;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ProtobufFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;

    public ProtobufFactory() {
    }

    public ProtobufFactory(ObjectCodec codec) {
        super(codec);
    }

    protected ProtobufFactory(ProtobufFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
    }

    public ProtobufFactory copy() {
        this._checkInvalidCopy(ProtobufFactory.class);
        return new ProtobufFactory(this, null);
    }

    protected Object readResolve() {
        return new ProtobufFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return "protobuf";
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return true;
    }

    public ProtobufParser createParser(File f) throws IOException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    public ProtobufParser createParser(URL url) throws IOException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    public ProtobufParser createParser(InputStream in) throws IOException {
        return this._createParser(in, this._createContext(in, false));
    }

    public ProtobufParser createParser(byte[] data) throws IOException {
        return this._createParser(data, 0, data.length, this._createContext(data, true));
    }

    public ProtobufParser createParser(byte[] data, int offset, int len) throws IOException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    public ProtobufGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        out = this._decorate(out, ctxt);
        return this._createProtobufGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    public ProtobufGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        out = this._decorate(out, ctxt);
        return this._createProtobufGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    protected IOContext _createContext(Object srcRef, boolean resourceManaged) {
        return super._createContext(srcRef, resourceManaged);
    }

    protected ProtobufParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        byte[] buf = ctxt.allocReadIOBuffer();
        return new ProtobufParser(ctxt, this._parserFeatures, this._objectCodec, in, buf, 0, 0, true);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    protected ProtobufParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new ProtobufParser(ctxt, this._parserFeatures, this._objectCodec, null, data, offset, len, false);
    }

    protected ProtobufGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return (ProtobufGenerator)((Object)this._nonByteTarget());
    }

    protected ProtobufGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createProtobufGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        return (Writer)this._nonByteTarget();
    }

    private final ProtobufGenerator _createProtobufGenerator(IOContext ctxt, int stdFeat, ObjectCodec codec, OutputStream out) throws IOException {
        return new ProtobufGenerator(ctxt, stdFeat, this._objectCodec, out);
    }

    protected <T> T _nonByteTarget() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected <T> T _nonByteSource() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based source");
    }
}

