/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf.schemagen;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.EnumConstantElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.EnumElement;
import com.fasterxml.jackson.dataformat.protobuf.protoparser.protoparser.TypeElement;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefaultTagGenerator;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.DefinedTypeElementBuilders;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.TypeElementBuilder;
import java.util.Set;

public class EnumElementVisitor
extends JsonStringFormatVisitor.Base
implements TypeElementBuilder {
    EnumElement.Builder _builder;
    DefaultTagGenerator _tagGenerator = new DefaultTagGenerator(0);

    public EnumElementVisitor(SerializerProvider provider, JavaType type, DefinedTypeElementBuilders definedTypeElementBuilders, boolean isNested) {
        if (!type.isEnumType()) {
            throw new IllegalArgumentException("Expected an enum, however given type is " + type);
        }
        this._builder = EnumElement.builder();
        this._builder.name(type.getRawClass().getSimpleName());
        this._builder.documentation("Enum for " + type.toCanonical());
        definedTypeElementBuilders.AddTypeElement(type, this, isNested);
    }

    @Override
    public TypeElement build() {
        return this._builder.build();
    }

    public void enumTypes(Set<String> enums) {
        for (String eName : enums) {
            this._builder.addConstant(this.buildEnumConstant(eName));
        }
    }

    protected EnumConstantElement buildEnumConstant(String name) {
        EnumConstantElement.Builder builder = EnumConstantElement.builder();
        builder.name(name);
        builder.tag(this._tagGenerator.nextTag());
        return builder.build();
    }
}

