/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.demo;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.monarchinitiative.hpotextmining.gui.controller.HpoTextMining;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private final Stage owner;
    private final URL scigraphUrl;
    private final ExecutorService executorService;
    private final Ontology ontology;

    Controller(Stage owner, URL scigraphUrl, ExecutorService executorService, Ontology ontology) {
        this.owner = owner;
        this.scigraphUrl = scigraphUrl;
        this.executorService = executorService;
        this.ontology = ontology;
    }

    @FXML
    public void runTextMIningAnalysisAction() {
        try {
            HpoTextMining hpoTextMining = HpoTextMining.builder().withSciGraphUrl(this.scigraphUrl).withOntology(this.ontology).withExecutorService(this.executorService).withPhenotypeTerms(new HashSet()).build();
            Stage secondary = new Stage();
            secondary.initOwner((Window)this.owner);
            secondary.setTitle("HPO text mining analysis");
            secondary.setScene(new Scene(hpoTextMining.getMainParent()));
            secondary.showAndWait();
            System.out.println(hpoTextMining.getApprovedTerms().stream().map(Object::toString).collect(Collectors.joining("\n", "Approved terms:\n", "")));
        }
        catch (IOException e) {
            LOGGER.warn("Error occured during text mining analysis", (Throwable)e);
        }
    }
}

