/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.gui.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;
import org.monarchinitiative.phenol.ontology.data.Term;

public class Main {
    @FXML
    public StackPane leftStackPane;
    @FXML
    private StackPane textMiningStackPane;
    private Set<PhenotypeTerm> terms = new HashSet<PhenotypeTerm>();
    @FXML
    private TableView<PhenotypeTerm> hpoTermsTableView;
    @FXML
    private TableColumn<PhenotypeTerm, String> hpoIdTableColumn;
    @FXML
    private TableColumn<PhenotypeTerm, String> hpoNameTableColumn;
    @FXML
    private TableColumn<PhenotypeTerm, String> observedTableColumn;
    @FXML
    private TableColumn<PhenotypeTerm, String> definitionTableColumn;

    void setTextMiningContent(Node content) {
        this.textMiningStackPane.getChildren().clear();
        this.textMiningStackPane.getChildren().add((Object)content);
    }

    void setLeftStackPaneContent(Node content) {
        this.leftStackPane.getChildren().clear();
        this.leftStackPane.getChildren().add((Object)content);
    }

    Set<PhenotypeTerm> getPhenotypeTerms() {
        return new HashSet<PhenotypeTerm>((Collection<PhenotypeTerm>)this.hpoTermsTableView.getItems());
    }

    void addPhenotypeTerms(Set<PhenotypeTerm> terms) {
        for (PhenotypeTerm term : terms) {
            this.addPhenotypeTerm(term);
        }
    }

    void addPhenotypeTerm(PhenotypeTerm term) {
        if (this.hpoTermsTableView == null) {
            this.terms.add(term);
        } else if (!this.hpoTermsTableView.getItems().contains((Object)term)) {
            this.hpoTermsTableView.getItems().add((Object)term);
        }
    }

    @FXML
    void removeButtonAction() {
        this.hpoTermsTableView.getItems().removeAll((Collection)this.hpoTermsTableView.getSelectionModel().getSelectedItems());
    }

    public void initialize() {
        this.hpoIdTableColumn.setCellValueFactory(cdf -> new ReadOnlyStringWrapper(((PhenotypeTerm)cdf.getValue()).getTerm().getId().getValue()));
        this.hpoNameTableColumn.setCellValueFactory(cdf -> new ReadOnlyStringWrapper(((PhenotypeTerm)cdf.getValue()).getTerm().getName()));
        this.observedTableColumn.setCellValueFactory(cdf -> new ReadOnlyStringWrapper(((PhenotypeTerm)cdf.getValue()).isPresent() ? "YES" : "NOT"));
        this.definitionTableColumn.setCellValueFactory(cdf -> new ReadOnlyStringWrapper(((PhenotypeTerm)cdf.getValue()).getTerm().getDefinition()));
        if (!this.terms.isEmpty()) {
            this.hpoTermsTableView.getItems().addAll(this.terms);
        }
    }

    @FXML
    public void removeTermButtonAction() {
        if (!this.hpoTermsTableView.getItems().isEmpty()) {
            ArrayList<PhenotypeTerm> toBeRemoved = new ArrayList<PhenotypeTerm>();
            for (Integer index : this.hpoTermsTableView.getSelectionModel().getSelectedIndices()) {
                toBeRemoved.add((PhenotypeTerm)this.hpoTermsTableView.getItems().get(index.intValue()));
            }
            this.hpoTermsTableView.getItems().removeAll(toBeRemoved);
        }
    }

    @FXML
    public void confirmAndClose() {
        Stage stage = (Stage)this.leftStackPane.getScene().getWindow();
        stage.close();
    }

    public static class PhenotypeTerm {
        private final Term term;
        private final int begin;
        private final int end;
        private final boolean present;

        public PhenotypeTerm(Term term, MinedTerm minedTerm) {
            this.term = term;
            this.begin = minedTerm.getBegin();
            this.end = minedTerm.getEnd();
            this.present = minedTerm.isPresent();
        }

        public PhenotypeTerm(Term term, boolean present) {
            this(term, -1, -1, present);
        }

        public PhenotypeTerm(Term term, int begin, int end, boolean present) {
            this.term = term;
            this.begin = begin;
            this.end = end;
            this.present = present;
        }

        public PhenotypeTerm(PhenotypeTerm other, boolean present) {
            this.term = other.term;
            this.begin = other.begin;
            this.end = other.end;
            this.present = present;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isPresent() {
            return this.present;
        }

        public Term getTerm() {
            return this.term;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhenotypeTerm that = (PhenotypeTerm)o;
            return this.term.getId().getValue().equals(that.term.getId().getValue()) && this.begin == that.begin && this.end == that.end && this.present == that.present;
        }

        public int hashCode() {
            return Objects.hash(this.term.getId().getValue(), this.begin, this.end, this.present);
        }

        public String toString() {
            return "PhenotypeTerm{term=" + this.term + ", begin=" + this.begin + ", end=" + this.end + ", present=" + this.present + "}";
        }
    }

    static enum Signal {
        DONE,
        CANCELLED,
        FAILED;

    }
}

