/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.gui.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.monarchinitiative.hpotextmining.gui.controller.Main;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Present {
    private static final Logger LOGGER = LoggerFactory.getLogger(Present.class);
    private static final String HTML_HEAD = "<html><head><style> .tooltip { position: relative; display: inline-block; border-bottom: 1px dotted black; }.tooltip .tooltiptext { visibility: hidden; width: 230px; background-color: #555; color: #fff; text-align: left; border-radius: 6px; padding: 5px 0; position: absolute; z-index: 1; bottom: 125%; left: 50%; margin-left: -60px; opacity: 0; transition: opacity 1s; }.tooltip .tooltiptext::after { content: \"\"; position: absolute; top: 100%; left: 50%; margin-left: -5px; border-width: 5px; border-style: solid; border-color: #555 transparent transparent transparent; }.tooltip:hover .tooltiptext { visibility: visible; opacity: 1;}</style><script>function focusOnTermJS(obj) {javafx_bridge.focusToTerm(obj);}</script></head>";
    private static final String HTML_BODY_BEGIN = "<body><h2>HPO text-mining analysis terms:</h2><p>";
    private static final String HTML_BODY_END = "</p></body></html>";
    private static final String HIGHLIGHTED_TEMPLATE = " <span class=\"tooltip\" style=\"color:red;\" onclick=\"focusOnTermJS('%s')\">%s<span class=\"tooltiptext\">%s</span></span>";
    private static final String TOOLTIP_TEMPLATE = "%s\n%s";
    private final Consumer<TermId> focusToTermHook;
    private final Consumer<Main.Signal> signal;
    @FXML
    private WebView webView;
    private WebEngine webEngine;
    @FXML
    private Button addTermsButton;
    @FXML
    private Button cancelButton;
    @FXML
    private VBox yesTermsVBox;
    @FXML
    private VBox notTermsVBox;
    @FXML
    private ScrollPane notTermScrollPane;
    @FXML
    private ScrollPane yesTermScrollPane;
    private ObservableSet<Main.PhenotypeTerm> yesTerms = FXCollections.observableSet((Object[])new Main.PhenotypeTerm[0]);
    private ObservableSet<Main.PhenotypeTerm> notTerms = FXCollections.observableSet((Object[])new Main.PhenotypeTerm[0]);
    private ObservableSet<Term> checkBoxesState = FXCollections.observableSet((Object[])new Term[0]);

    Present(Consumer<Main.Signal> signal, Consumer<TermId> focusToTermHook) {
        this.signal = signal;
        this.focusToTermHook = focusToTermHook;
    }

    private static CheckBox checkBoxFactory(Main.PhenotypeTerm term) {
        CheckBox cb = new CheckBox(term.getTerm().getName());
        cb.setPadding(new Insets(5.0));
        cb.setUserData((Object)term);
        return cb;
    }

    private static List<Main.PhenotypeTerm> deduplicate(Collection<Main.PhenotypeTerm> terms) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<Main.PhenotypeTerm> deduplicated = new ArrayList<Main.PhenotypeTerm>();
        for (Main.PhenotypeTerm term : terms) {
            if (!ids.contains(term.getTerm().getId().getId())) {
                deduplicated.add(term);
            }
            ids.add(term.getTerm().getId().getId());
        }
        return deduplicated;
    }

    private String colorizeHTML4ciGraph(Collection<Main.PhenotypeTerm> terms, String query) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append(HTML_HEAD);
        htmlBuilder.append(HTML_BODY_BEGIN);
        List sortedByBegin = terms.stream().sorted(Comparator.comparing(Main.PhenotypeTerm::getBegin)).collect(Collectors.toList());
        int offset = 0;
        for (Main.PhenotypeTerm term : sortedByBegin) {
            int start = Math.max(term.getBegin(), offset);
            htmlBuilder.append(query, offset, start);
            start = Math.min(start, term.getBegin());
            htmlBuilder.append(String.format(HIGHLIGHTED_TEMPLATE, term.getTerm().getId().getValue(), query.substring(start, term.getEnd()), String.format(TOOLTIP_TEMPLATE, term.getTerm().getId().getValue(), term.getTerm().getName())));
            offset = term.getEnd();
        }
        htmlBuilder.append(query.substring(offset));
        htmlBuilder.append(HTML_BODY_END);
        return htmlBuilder.toString().replaceAll("\\s{2,}", " ").trim();
    }

    @FXML
    void addTermsButtonAction() {
        this.signal.accept(Main.Signal.DONE);
    }

    @FXML
    void cancelButtonAction() {
        this.signal.accept(Main.Signal.CANCELLED);
    }

    public void initialize() {
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                JSObject win = (JSObject)this.webEngine.executeScript("window");
                win.setMember("javafx_bridge", new JavaBridge());
                this.webEngine.executeScript("console.log = function(message) {javafx_bridge.log(message);};");
            }
        });
        this.yesTerms.addListener((SetChangeListener)new SetChangeListener<Main.PhenotypeTerm>(){

            public void onChanged(SetChangeListener.Change<? extends Main.PhenotypeTerm> change) {
                Present.this.yesTermsVBox.getChildren().clear();
                change.getSet().stream().sorted(Comparator.comparing(a -> a.getTerm().getName())).map(phenotype -> Present.checkBoxFactory(phenotype)).forEach(arg_0 -> Present.this.yesTermsVBox.getChildren().add(arg_0));
            }
        });
        this.notTerms.addListener((SetChangeListener)new SetChangeListener<Main.PhenotypeTerm>(){

            public void onChanged(SetChangeListener.Change<? extends Main.PhenotypeTerm> change) {
                Present.this.notTermsVBox.getChildren().clear();
                change.getSet().stream().sorted(Comparator.comparing(a -> a.getTerm().getName())).map(phenotype -> Present.checkBoxFactory(phenotype)).forEach(arg_0 -> Present.this.notTermsVBox.getChildren().add(arg_0));
            }
        });
        ListChangeListener<Node> changeListener = new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    c.getAddedSubList().forEach(node -> {
                        CheckBox checkBox = (CheckBox)node;
                        checkBox.setOnDragDetected(event -> {
                            Dragboard db = checkBox.startDragAndDrop(TransferMode.ANY);
                            ClipboardContent draggedTerm = new ClipboardContent();
                            draggedTerm.putString(checkBox.getText());
                            LOGGER.debug("dragged item: " + checkBox.getText());
                            db.setContent((Map)draggedTerm);
                            event.consume();
                        });
                        checkBox.setOnDragDone(event -> {
                            if (event.getTransferMode() == TransferMode.MOVE) {
                                LOGGER.debug("drag and drop completed");
                            }
                            event.consume();
                        });
                        if (Present.this.checkBoxesState.contains((Object)((Main.PhenotypeTerm)checkBox.getUserData()).getTerm())) {
                            checkBox.setSelected(true);
                        } else {
                            checkBox.setSelected(false);
                        }
                        checkBox.selectedProperty().addListener((selected, oldvalue, newvalue) -> {
                            if (newvalue.booleanValue()) {
                                Present.this.checkBoxesState.add((Object)((Main.PhenotypeTerm)checkBox.getUserData()).getTerm());
                            } else {
                                Present.this.checkBoxesState.remove((Object)((Main.PhenotypeTerm)checkBox.getUserData()).getTerm());
                            }
                        });
                    });
                }
            }
        };
        this.yesTermsVBox.getChildren().addListener((ListChangeListener)changeListener);
        this.notTermsVBox.getChildren().addListener((ListChangeListener)changeListener);
        this.notTermScrollPane.setOnDragEntered(event -> {
            this.notTermScrollPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)}));
            event.consume();
        });
        this.notTermScrollPane.setOnDragExited(event -> {
            this.notTermScrollPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
            event.consume();
        });
        this.notTermScrollPane.setOnDragOver(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.notTermScrollPane.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasString()) {
                String dragged = dragboard.getString();
                Optional<Main.PhenotypeTerm> dragged_term = this.yesTerms.stream().filter(t -> t.getTerm().getName().equals(dragged)).findFirst();
                dragged_term.ifPresent(arg_0 -> this.yesTerms.remove(arg_0));
                dragged_term.ifPresent(phenotypeTerm -> this.notTerms.add((Object)new Main.PhenotypeTerm((Main.PhenotypeTerm)phenotypeTerm, false)));
                event.setDropCompleted(true);
            }
            event.consume();
        });
        this.yesTermScrollPane.setOnDragEntered(event -> {
            this.yesTermScrollPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)}));
            event.consume();
        });
        this.yesTermScrollPane.setOnDragExited(event -> {
            this.yesTermScrollPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
            event.consume();
        });
        this.yesTermScrollPane.setOnDragOver(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.yesTermScrollPane.setOnDragDropped(event -> {
            Dragboard dragboard = event.getDragboard();
            if (dragboard.hasString()) {
                String dragged = dragboard.getString();
                Optional<Main.PhenotypeTerm> dragged_term = this.notTerms.stream().filter(t -> t.getTerm().getName().equals(dragged)).findFirst();
                dragged_term.ifPresent(arg_0 -> this.notTerms.remove(arg_0));
                dragged_term.ifPresent(phenotypeTerm -> this.yesTerms.add((Object)new Main.PhenotypeTerm((Main.PhenotypeTerm)phenotypeTerm, true)));
                event.setDropCompleted(true);
            }
            event.consume();
        });
    }

    void setResults(Collection<Main.PhenotypeTerm> terms, String query) {
        this.yesTerms.clear();
        this.notTerms.clear();
        List<Main.PhenotypeTerm> termList = Present.deduplicate(terms);
        termList.sort(Comparator.comparing(t -> t.getTerm().getName()));
        termList.stream().filter(t -> t.isPresent()).forEach(arg_0 -> this.yesTerms.add(arg_0));
        termList.stream().filter(t -> !t.isPresent()).forEach(arg_0 -> this.notTerms.add(arg_0));
        String html = this.colorizeHTML4ciGraph(termList, query);
        this.webEngine.loadContent(html);
    }

    Set<Main.PhenotypeTerm> getApprovedTerms() {
        CheckBox b;
        ArrayList<CheckBox> boxes = new ArrayList<CheckBox>();
        for (Node child : this.yesTermsVBox.getChildren()) {
            b = (CheckBox)child;
            boxes.add(b);
        }
        for (Node child : this.notTermsVBox.getChildren()) {
            b = (CheckBox)child;
            boxes.add(b);
        }
        return boxes.stream().filter(CheckBox::isSelected).map(cb -> (Main.PhenotypeTerm)cb.getUserData()).collect(Collectors.toSet());
    }

    public class JavaBridge {
        public void log(String message) {
            LOGGER.info(message);
        }

        public void focusToTerm(String termId) {
            LOGGER.debug("Focusing on term with ID {}", (Object)termId);
            TermId id = TermId.of((String)termId);
            Present.this.focusToTermHook.accept(id);
        }
    }
}

