/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.monospark.remix.internal.RecordParameter;

class BooleanResolver {
    BooleanResolver() {
    }

    static <R extends Record> RecordParameter resolveParameter(List<RecordParameter> parameters, List<R> instances, Function<R, Boolean> methodRef) {
        Class<?> c = parameters.get(0).getComponent().getDeclaringRecord();
        for (int i = 0; i < parameters.size(); ++i) {
            Class<?> type = parameters.get(i).getComponent().getType();
            if (!type.equals(Boolean.TYPE) && !type.equals(Boolean.class) || !BooleanResolver.matches(parameters.get(i), instances, methodRef)) continue;
            return parameters.get(i);
        }
        throw new IllegalArgumentException("Could not resolve boolean record component, thereforethe method reference does not belong to the associated record class.");
    }

    private static <R extends Record> boolean matches(RecordParameter parameter, List<R> instances, Function<R, Boolean> methodRef) {
        for (Record r : instances) {
            try {
                Object shouldBe;
                Boolean query = methodRef.apply(r);
                if (query.equals(shouldBe = parameter.getComponent().getAccessor().invoke((Object)r, new Object[0]))) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    static <R extends Record> List<R> createInstances(List<RecordParameter> parameters) {
        long booleans = parameters.stream().filter(p -> p.getComponent().getType().equals(Boolean.TYPE) || p.getComponent().getType().equals(Boolean.class)).count();
        int neededInstances = (int)booleans;
        ArrayList<R> list = new ArrayList<R>(neededInstances);
        for (int i = 0; i < neededInstances; ++i) {
            list.add(BooleanResolver.createValue(parameters, i));
        }
        return list;
    }

    private static <R extends Record> R createValue(List<RecordParameter> parameters, int value) {
        Object[] values = new Object[parameters.size()];
        int booleans = 0;
        Class<?> c = parameters.get(0).getComponent().getDeclaringRecord();
        for (int i = 0; i < parameters.size(); ++i) {
            Class<?> type = parameters.get(i).getComponent().getType();
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                values[i] = booleans == value;
                ++booleans;
                continue;
            }
            values[i] = parameters.get(i).defaultValue();
        }
        try {
            return (R)((Record)c.getDeclaredConstructors()[0].newInstance(values));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

