/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.Map;
import java.util.function.Supplier;
import org.monospark.remix.RecordBlank;
import org.monospark.remix.RecordBuilder;
import org.monospark.remix.internal.RecordBuilderImpl;
import org.monospark.remix.internal.RecordParameter;

public final class RecordBlankImpl<R extends Record>
extends RecordBlank<R> {
    private Class<R> recordClass;
    private Map<RecordParameter, Supplier<?>> mapping;

    RecordBlankImpl(Class<R> recordClass, Map<RecordParameter, Supplier<?>> mapping) {
        this.recordClass = recordClass;
        this.mapping = Map.copyOf(mapping);
    }

    @Override
    protected RecordBuilder<R> builder() {
        return new RecordBuilderImpl<R>(this.recordClass, this.mapping);
    }

    @Override
    protected <T> Supplier<T> getValue(RecordParameter p) {
        return this.mapping.get(p);
    }
}

