/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.monospark.remix.LambdaSupport;
import org.monospark.remix.RecordBlank;
import org.monospark.remix.RecordBuilder;
import org.monospark.remix.RecordBuilderException;
import org.monospark.remix.Records;
import org.monospark.remix.internal.RecordBlankImpl;
import org.monospark.remix.internal.RecordCache;
import org.monospark.remix.internal.RecordCacheData;
import org.monospark.remix.internal.RecordParameter;
import org.monospark.remix.internal.RecordResolver;

public final class RecordBuilderImpl<R extends Record>
implements RecordBuilder<R> {
    private Class<R> recordClass;
    private RecordCacheData<R> cacheData;
    private Map<RecordParameter, Supplier<?>> mapping;

    RecordBuilderImpl(Class<R> recordClass, Map<RecordParameter, Supplier<?>> mapping) {
        this.cacheData = RecordCache.getOrAdd(recordClass);
        this.recordClass = recordClass;
        this.mapping = new HashMap(mapping);
    }

    public RecordBuilderImpl(Class<R> recordClass) {
        this.cacheData = RecordCache.getOrAdd(recordClass);
        this.recordClass = recordClass;
        this.mapping = new HashMap();
    }

    @Override
    public R build() {
        Object[] args = new Object[this.cacheData.getParameters().size()];
        int i = 0;
        for (RecordParameter p : this.cacheData.getParameters()) {
            args[i] = !this.mapping.containsKey(p) ? p.defaultValue() : this.mapping.get(p).get();
            ++i;
        }
        try {
            return Records.create(this.recordClass, args);
        }
        catch (Exception e) {
            throw new RecordBuilderException("Could not create record instance", e);
        }
    }

    @Override
    public RecordBlank<R> blank() {
        return new RecordBlankImpl<R>(this.recordClass, this.mapping);
    }

    @Override
    public <T> RecordBuilder.ComponentContext<R, T> set(final Function<R, T> component) {
        return new RecordBuilder.ComponentContext<R, T>(){

            @Override
            public RecordBuilder<R> to(Supplier<T> value) {
                RecordResolver.ParameterValue result = RecordBuilderImpl.this.cacheData.getResolverCache().resolve(component, value);
                if (result != null) {
                    RecordBuilderImpl.this.mapping.put(result.parameter(), value);
                }
                return RecordBuilderImpl.this;
            }
        };
    }

    @Override
    public <T> RecordBuilder.ComponentContext<R, T> set(final LambdaSupport.WrappedFunction<R, T> component) {
        return new RecordBuilder.ComponentContext<R, T>(){

            @Override
            public RecordBuilder<R> to(Supplier<T> value) {
                RecordParameter param = RecordBuilderImpl.this.cacheData.getResolverCache().resolveWrapped(component);
                RecordBuilderImpl.this.mapping.put(param, value);
                return RecordBuilderImpl.this;
            }
        };
    }
}

