/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.lang.reflect.Constructor;
import java.util.List;
import org.monospark.remix.RecordRemixer;
import org.monospark.remix.Remix;
import org.monospark.remix.RemixException;
import org.monospark.remix.internal.RecordParameter;
import org.monospark.remix.internal.RecordRemixCache;
import org.monospark.remix.internal.RecordRemixImpl;
import org.monospark.remix.internal.RecordResolver;

public class RecordCacheData<T extends Record> {
    private RecordRemixImpl<T> remix;
    private Constructor<T> constructor;
    private List<RecordParameter> parameters;
    private RecordResolver<T> resolverCache;

    public RecordCacheData(RecordRemixImpl<T> remix, Constructor<T> constructor, List<RecordParameter> parameters) {
        this.remix = remix;
        this.constructor = constructor;
        this.parameters = parameters;
    }

    private static boolean hasRemixAnnotation(Class<? extends Record> recordClass) {
        return ((Remix[])recordClass.getAnnotationsByType(Remix.class)).length > 0;
    }

    static <R extends Record, T extends RecordRemixer<R>> RecordCacheData<R> fromRecordClass(Class<R> recordClass, RecordRemixer<R> remixer) {
        RecordRemixImpl<R> remix = new RecordRemixImpl<R>(recordClass);
        if (RecordCacheData.hasRemixAnnotation(recordClass) || remixer != null) {
            if (recordClass.getDeclaredConstructors().length > 1) {
                throw new RemixException("More than one constructors declared");
            }
            if (remixer != null) {
                remixer.create(remix);
            } else {
                Class<? extends RecordRemixer<? extends Record>> clazz = recordClass.getAnnotation(Remix.class).value();
                RecordRemixCache.getOrAddRecordRemixer(clazz).create(remix);
            }
        }
        Constructor<?> cons = recordClass.getDeclaredConstructors()[0];
        cons.setAccessible(true);
        return new RecordCacheData<R>(remix, cons, RecordParameter.fromRecordComponents(recordClass));
    }

    public RecordResolver<T> getResolverCache() {
        if (this.resolverCache == null) {
            this.resolverCache = new RecordResolver<T>(this.constructor, this.parameters);
        }
        return this.resolverCache;
    }

    public List<RecordParameter> getParameters() {
        return this.parameters;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public RecordRemixImpl<T> getRemix() {
        return this.remix;
    }
}

