/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.monospark.remix.LambdaSupport;
import org.monospark.remix.RecordOperations;
import org.monospark.remix.internal.RecordCache;
import org.monospark.remix.internal.RecordCacheData;
import org.monospark.remix.internal.RecordParameter;

public final class RecordOperationsImpl<R extends Record>
implements RecordOperations<R> {
    private final LambdaSupport.WrappedFunction<R, Object> all = r -> null;
    private Class<R> recordClass;
    private List<OperatorEntry<R, ?>> operatorEntries;
    private Map<RecordParameter, UnaryOperator<?>> parameterOperators;

    RecordOperationsImpl(Class<R> recordClass) {
        this.recordClass = recordClass;
        this.operatorEntries = new ArrayList();
        this.parameterOperators = new HashMap();
    }

    public <T> UnaryOperator<T> getOperator(RecordParameter param) {
        if (!this.parameterOperators.containsKey(param)) {
            RecordCacheData<R> d = RecordCache.getOrAdd(this.recordClass);
            ArrayList matchingEntries = new ArrayList();
            for (OperatorEntry<R, ?> e : this.operatorEntries) {
                if (!e.reference.equals(this.all) && !d.getResolverCache().resolveWrapped(e.reference).equals(param)) continue;
                matchingEntries.add(e);
            }
            if (matchingEntries.size() > 0) {
                this.parameterOperators.put(param, v -> {
                    Object obj = v;
                    for (OperatorEntry e : matchingEntries) {
                        obj = e.operator.apply(obj);
                    }
                    return obj;
                });
            } else {
                this.parameterOperators.put(param, null);
            }
        }
        return this.parameterOperators.get(param);
    }

    @Override
    public <T> RecordOperations<R> add(LambdaSupport.WrappedFunction<R, T> component, UnaryOperator<T> op) {
        Objects.requireNonNull(component, "Component must be not null");
        Objects.requireNonNull(op, "Operator must be not null");
        this.operatorEntries.add(new OperatorEntry<R, T>(component, op));
        return this;
    }

    @Override
    public <T> RecordOperations<R> notNull(LambdaSupport.WrappedFunction<R, T> component) {
        Objects.requireNonNull(component, "Component must be not null");
        return this.add(component, Objects::requireNonNull);
    }

    @Override
    public <T> RecordOperations<R> check(LambdaSupport.WrappedFunction<R, T> component, Predicate<T> toCheck) {
        Objects.requireNonNull(component, "Component must be not null");
        Objects.requireNonNull(toCheck, "Predicate must be not null");
        return this.add(component, v -> {
            if (!toCheck.test(v)) {
                throw new IllegalArgumentException("Condition not met");
            }
            return v;
        });
    }

    @Override
    public <T> LambdaSupport.WrappedFunction<R, T> all() {
        return this.all;
    }

    private record OperatorEntry<R extends Record, T>(LambdaSupport.WrappedFunction<R, T> reference, UnaryOperator<T> operator) {
    }
}

