/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.Map;
import org.monospark.remix.Mutable;
import org.monospark.remix.MutableBoolean;
import org.monospark.remix.Wrapped;
import org.monospark.remix.WrappedBoolean;
import org.monospark.remix.WrappedInt;
import org.monospark.remix.internal.DefaultValueHelper;
import org.monospark.remix.internal.MutableBooleanImpl;
import org.monospark.remix.internal.MutableImpl;
import org.monospark.remix.internal.RecordParameter;
import org.monospark.remix.internal.WrappedBooleanImpl;
import org.monospark.remix.internal.WrappedImpl;
import org.monospark.remix.internal.WrappedIntImpl;

public abstract class RecordComponentType {
    private static final Map<Class<?>, RecordComponentType> TYPES = Map.of(Wrapped.class, new WrappedObjectType(), WrappedBoolean.class, new WrappedBooleanType(), WrappedInt.class, new WrappedIntType(), Mutable.class, new MutableType(), MutableBoolean.class, new MutableBooleanType());

    static RecordComponentType get(Class<?> type) {
        return TYPES.getOrDefault(type, new BareType(type));
    }

    abstract boolean isMutable();

    abstract boolean isWrapped();

    public abstract Object wrap(RecordParameter var1, Object var2);

    public abstract Object unwrap(Object var1);

    public abstract Object defaultValue(RecordParameter var1);

    public abstract Class<?> getValueType();

    public static final class BareType
    extends RecordComponentType {
        private Class<?> clazz;

        public BareType(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        boolean isMutable() {
            return false;
        }

        @Override
        boolean isWrapped() {
            return false;
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return value;
        }

        @Override
        public Object unwrap(Object value) {
            return value;
        }

        @Override
        public Object defaultValue(RecordParameter param) {
            return DefaultValueHelper.createDefaultValue(this.clazz);
        }

        @Override
        public Class<?> getValueType() {
            return this.clazz;
        }
    }

    public static class WrappedObjectType
    extends RecordComponentType {
        @Override
        boolean isMutable() {
            return false;
        }

        @Override
        boolean isWrapped() {
            return true;
        }

        @Override
        public Object unwrap(Object value) {
            return ((WrappedImpl)value).get();
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return new WrappedImpl<Object>(param, value);
        }

        @Override
        public Object defaultValue(RecordParameter param) {
            return null;
        }

        @Override
        public Class<?> getValueType() {
            return Object.class;
        }
    }

    public static class WrappedBooleanType
    extends RecordComponentType {
        @Override
        boolean isMutable() {
            return false;
        }

        @Override
        boolean isWrapped() {
            return true;
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return new WrappedBooleanImpl(param, (Boolean)value);
        }

        @Override
        public Object unwrap(Object value) {
            return ((WrappedBooleanImpl)value).value;
        }

        @Override
        public Object defaultValue(RecordParameter param) {
            return false;
        }

        @Override
        public Class<?> getValueType() {
            return Boolean.TYPE;
        }
    }

    public static final class WrappedIntType
    extends RecordComponentType {
        @Override
        boolean isMutable() {
            return false;
        }

        @Override
        boolean isWrapped() {
            return true;
        }

        @Override
        public Object unwrap(Object value) {
            return ((WrappedIntImpl)value).getInt();
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return new WrappedIntImpl(param, (Integer)value);
        }

        @Override
        public Object defaultValue(RecordParameter param) {
            return 0;
        }

        public Class<Integer> getValueType() {
            return Integer.TYPE;
        }
    }

    public static final class MutableType
    extends WrappedObjectType {
        @Override
        boolean isMutable() {
            return true;
        }

        @Override
        public Object unwrap(Object value) {
            return ((MutableImpl)value).get();
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return new MutableImpl<Object>(param, value);
        }
    }

    public static final class MutableBooleanType
    extends WrappedBooleanType {
        @Override
        boolean isMutable() {
            return true;
        }

        @Override
        public Object wrap(RecordParameter param, Object value) {
            return new MutableBooleanImpl(param, (Boolean)value);
        }
    }
}

