/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.monospark.remix.RemixException;
import org.monospark.remix.internal.RecordCache;
import org.monospark.remix.internal.RecordComponentType;

public final class RecordParameter
implements Serializable {
    private RecordComponent component;
    private RecordComponentType type;

    public RecordParameter(RecordComponent component, RecordComponentType type) {
        this.component = component;
        this.type = type;
    }

    public static List<RecordParameter> fromRecordComponents(Class<?> recordClass) {
        List<RecordParameter> params = Arrays.stream(recordClass.getRecordComponents()).map(comp -> {
            RecordComponent component = comp;
            RecordComponentType type = RecordComponentType.get(comp.getType());
            return new RecordParameter(component, type);
        }).collect(Collectors.toList());
        return params;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.component.getDeclaringRecord());
        out.writeInt(Arrays.asList(this.getRecord().getRecordComponents()).stream().map(RecordComponent::getName).collect(Collectors.toList()).indexOf(this.component.getName()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class c = (Class)in.readObject();
        int index = in.readInt();
        this.component = c.getRecordComponents()[index];
        this.type = RecordComponentType.get(c.getRecordComponents()[index].getType());
    }

    public Object wrap(Object value) {
        return this.getType().wrap(this, value);
    }

    public Object getValue(Object instance) {
        try {
            this.getComponent().getAccessor().setAccessible(true);
            return this.getComponent().getAccessor().invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RemixException(e);
        }
    }

    public Object unwrap(Object value) {
        return this.getType().unwrap(value);
    }

    public Object defaultValue() {
        return this.getType().defaultValue(this);
    }

    public <T extends Record> Class<T> getRecord() {
        return this.component.getDeclaringRecord();
    }

    public boolean isWrapped() {
        return this.type.isWrapped();
    }

    public boolean isMutable() {
        return this.type.isMutable();
    }

    public RecordComponent getComponent() {
        return this.component;
    }

    public RecordComponentType getType() {
        return this.type;
    }

    public <T> UnaryOperator<T> getGetOperation() {
        return RecordCache.getOrAdd(this.getRecord()).getRemix().getGetOperations().getOperator(this);
    }

    public <T> UnaryOperator<T> getSetOperation() {
        return RecordCache.getOrAdd(this.getRecord()).getRemix().getSetOperations().getOperator(this);
    }
}

