/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.function.Consumer;
import org.monospark.remix.RecordBlank;
import org.monospark.remix.RecordBuilder;
import org.monospark.remix.RecordOperations;
import org.monospark.remix.RecordRemix;
import org.monospark.remix.internal.RecordBlankImpl;
import org.monospark.remix.internal.RecordBuilderImpl;
import org.monospark.remix.internal.RecordOperationsImpl;

public final class RecordRemixImpl<T extends Record>
implements RecordRemix<T> {
    private Class<T> clazz;
    private RecordBlank<T> blank;
    private Consumer<RecordBuilder<T>> blankBuilder;
    private RecordOperationsImpl<T> getOperations;
    private RecordOperationsImpl<T> assignOperations;
    private RecordOperationsImpl<T> setOperations;
    private RecordOperationsImpl<T> copyOperations;

    RecordRemixImpl(Class<T> clazz) {
        this.clazz = clazz;
        this.getOperations = new RecordOperationsImpl<T>(clazz);
        this.assignOperations = new RecordOperationsImpl<T>(clazz);
    }

    @Override
    public void blank(Consumer<RecordBuilder<T>> builder) {
        this.blankBuilder = builder;
    }

    @Override
    public void copy(Consumer<RecordOperations<T>> operations) {
        this.copyOperations = new RecordOperationsImpl<T>(this.clazz);
        operations.accept(this.copyOperations);
    }

    @Override
    public void get(Consumer<RecordOperations<T>> operations) {
        operations.accept(this.getOperations);
    }

    @Override
    public void assign(Consumer<RecordOperations<T>> operations) {
        operations.accept(this.assignOperations);
    }

    @Override
    public void set(Consumer<RecordOperations<T>> operations) {
        this.setOperations = new RecordOperationsImpl<T>(this.clazz);
        operations.accept(this.setOperations);
    }

    public RecordBlankImpl<T> getBlank() {
        if (this.blank == null) {
            RecordBuilderImpl<T> b = new RecordBuilderImpl<T>(this.clazz);
            if (this.blankBuilder != null) {
                this.blankBuilder.accept(b);
            }
            this.blank = b.blank();
        }
        return (RecordBlankImpl)this.blank;
    }

    public RecordOperationsImpl<T> getGetOperations() {
        return this.getOperations;
    }

    public RecordOperationsImpl<T> getAssignOperations() {
        return this.assignOperations;
    }

    public RecordOperationsImpl<T> getSetOperations() {
        return this.setOperations != null ? this.setOperations : this.assignOperations;
    }

    public RecordOperationsImpl<T> getCopyOperations() {
        return this.copyOperations != null ? this.copyOperations : this.getOperations;
    }
}

