/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.monospark.remix.LambdaSupport;
import org.monospark.remix.RecordResolveException;
import org.monospark.remix.Records;
import org.monospark.remix.internal.BooleanResolver;
import org.monospark.remix.internal.DefaultValueHelper;
import org.monospark.remix.internal.RecordParameter;
import org.monospark.remix.internal.Wrapper;

public final class RecordResolver<R extends Record> {
    private List<RecordParameter> parameters;
    private R primitiveInstance;
    private Map<RecordParameter, Object> primitiveValueMap;
    private R wrapperInstance;
    private List<R> booleanResolveInstances;
    private R learnedObjectsInstance;
    private Map<RecordParameter, Object> cachedParameters;

    RecordResolver(Constructor<R> constructor, List<RecordParameter> parameters) {
        this.wrapperInstance = this.defaultRecordInstance(constructor, parameters);
        this.parameters = parameters;
        this.cachedParameters = new HashMap<RecordParameter, Object>();
        this.booleanResolveInstances = BooleanResolver.createInstances(parameters);
        this.primitiveValueMap = new HashMap<RecordParameter, Object>();
        this.primitiveInstance = this.createPrimitiveInstance();
        this.learnedObjectsInstance = this.createLearnedObjectsInstance();
    }

    public <T> RecordParameter resolveWrapped(LambdaSupport.WrappedFunction<R, T> methodRef) {
        Object wrapperValue = methodRef.apply(this.wrapperInstance);
        return ((Wrapper)wrapperValue).getRecordParameter();
    }

    public <T> ParameterValue<T> resolve(Function<R, T> methodRef, Supplier<T> valueSupplier) {
        T value = valueSupplier.get();
        if (value == null) {
            T query = methodRef.apply(this.learnedObjectsInstance);
            if (query == null) {
                return null;
            }
            for (RecordParameter p : this.parameters) {
                Object cached = this.cachedParameters.get(p);
                if (cached == null || cached != query) continue;
                return new ParameterValue<Object>(p, null);
            }
        } else {
            boolean boxed;
            if (value.getClass().equals(Boolean.class)) {
                return new ParameterValue<T>(this.resolveBoolean(methodRef), value);
            }
            boolean bl = boxed = methodRef.apply(this.primitiveInstance) != null;
            if (boxed) {
                for (RecordParameter p : this.parameters) {
                    if (!this.checkPrimitiveParameter(methodRef, p)) continue;
                    return new ParameterValue<T>(p, value);
                }
            } else {
                for (RecordParameter p : this.parameters) {
                    if (!this.checkAndCacheParameter(methodRef, p, value)) continue;
                    return new ParameterValue<T>(p, value);
                }
            }
        }
        throw new RecordResolveException("Could not resolve record component for input value " + valueSupplier.get().toString() + ", therefore the method reference does not belong to the associated record class");
    }

    private R defaultRecordInstance(Constructor<R> constructor, List<RecordParameter> parameters) {
        Object[] args = new Object[parameters.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = parameters.get(i).defaultValue();
        }
        R obj = Records.createRaw(constructor.getDeclaringClass(), args);
        return obj;
    }

    private RecordParameter resolveBoolean(Function<R, Boolean> methodRef) {
        return BooleanResolver.resolveParameter(this.parameters, this.booleanResolveInstances, methodRef);
    }

    private boolean checkPrimitiveParameter(Function<R, ?> methodRef, RecordParameter param) {
        Object query = methodRef.apply(this.primitiveInstance);
        return query.equals(this.primitiveValueMap.get(param));
    }

    private <T> boolean checkAndCacheParameter(Function<R, ?> methodRef, RecordParameter param, T value) {
        Object def;
        Object query = methodRef.apply(this.learnedObjectsInstance);
        if (query != (def = DefaultValueHelper.createDefaultValue(param.getComponent().getType())) && query == this.cachedParameters.get(param)) {
            return true;
        }
        this.cachedParameters.put(param, param.wrap(value));
        R obj = this.createLearnedObjectsInstance();
        query = methodRef.apply(obj);
        if (query != def && query == this.cachedParameters.get(param)) {
            this.learnedObjectsInstance = obj;
            return true;
        }
        this.cachedParameters.remove(param);
        return false;
    }

    private R createPrimitiveInstance() {
        Object[] values = new Object[this.parameters.size()];
        Class<?> c = this.parameters.get(0).getComponent().getDeclaringRecord();
        for (int i = 0; i < this.parameters.size(); ++i) {
            RecordParameter p = this.parameters.get(i);
            Class<?> type = p.getType().getValueType();
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                values[i] = false;
                continue;
            }
            if (type.isPrimitive() || DefaultValueHelper.isBoxedClass(type)) {
                values[i] = i;
                this.primitiveValueMap.put(p, i);
                continue;
            }
            values[i] = null;
        }
        return (R)Records.createRaw(c, values);
    }

    private R createLearnedObjectsInstance() {
        Object[] values = new Object[this.parameters.size()];
        Class<?> c = this.parameters.get(0).getComponent().getDeclaringRecord();
        for (int i = 0; i < this.parameters.size(); ++i) {
            RecordParameter p = this.parameters.get(i);
            values[i] = this.cachedParameters.containsKey(p) ? this.cachedParameters.get(p) : (p.getComponent().getType().equals(Boolean.TYPE) ? Boolean.valueOf(false) : (p.getComponent().getType().isPrimitive() ? Integer.valueOf(0) : p.defaultValue()));
        }
        return (R)Records.createRaw(c, values);
    }

    public record ParameterValue<T>(RecordParameter parameter, T value) {
    }
}

