/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.remix.internal;

import java.util.Objects;
import java.util.function.UnaryOperator;
import org.monospark.remix.Wrapped;
import org.monospark.remix.internal.RecordParameter;
import org.monospark.remix.internal.Wrapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class WrappedImpl<T>
extends Wrapper
implements Wrapped<T> {
    protected T value;

    public WrappedImpl(RecordParameter param, T value) {
        super(param);
        this.value = value;
    }

    public String toString() {
        return "Wrapped{" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedImpl wrapped = (WrappedImpl)o;
        return Objects.equals(this.value, wrapped.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public T get() {
        UnaryOperator ops = this.getRecordParameter().getGetOperation();
        if (ops != null) {
            return (T)this.getRecordParameter().getGetOperation().apply(this.value);
        }
        return this.value;
    }
}

