/*
Copyright 2020 Morgan Stanley

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package morphir.ir.codec

import morphir.ir.documented.Documented
import upickle.default._

object documentedCodecs {

  trait DocumentedCodec {

    implicit def documentedReadWriter[A: ReadWriter]: ReadWriter[Documented[A]] =
      readwriter[(String, A)].bimap[Documented[A]](
        instance => (instance.doc, instance.value),
        { case (docs, value) =>
          Documented(docs, value)
        }
      )

  }
}
