/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.AsyncRetryingCallable;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

public class AsyncRpcRetryingCaller<T> {
    static final Log LOG = LogFactory.getLog(AsyncRpcRetryingCaller.class);
    private int callTimeout;
    private long globalStartTime;
    private static final int MIN_RPC_TIMEOUT = 2000;
    private final long pause;
    private final int retries;

    public AsyncRpcRetryingCaller(long pause, int retries) {
        this.pause = pause;
        this.retries = retries;
    }

    public synchronized void callWithRetries(AsyncRetryingCallable<T> callable, ResponseHandler<T> handler) {
        this.callWithRetries(callable, Integer.MAX_VALUE, handler);
    }

    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="na")
    public synchronized void callWithRetries(AsyncRetryingCallable<T> callable, int callTimeout, ResponseHandler<T> handler) {
        this.callTimeout = callTimeout;
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        try {
            callable.prepare(true);
        }
        catch (IOException e) {
            handler.onFailure(e);
            return;
        }
        callable.call(new CallResponseHandler<T>(handler, callable));
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTimeMillis() - this.globalStartTime + 2000L + expectedSleep;
    }

    public void callWithoutRetries(AsyncRetryingCallable<T> callable, int callTimeout, final ResponseHandler<T> handler) {
        this.globalStartTime = EnvironmentEdgeManager.currentTimeMillis();
        this.callTimeout = callTimeout;
        try {
            callable.prepare(true);
        }
        catch (IOException e) {
            handler.onFailure(e);
            return;
        }
        callable.call(new ResponseHandler<T>(){

            @Override
            public void onSuccess(T response) {
                handler.onSuccess(response);
            }

            @Override
            public void onFailure(IOException e) {
                try {
                    Throwable t2 = AsyncRpcRetryingCaller.translateException(e);
                    ExceptionUtil.rethrowIfInterrupt((Throwable)t2);
                    if (!(t2 instanceof IOException)) {
                        throw new RuntimeException(t2);
                    }
                    handler.onFailure((IOException)t2);
                }
                catch (InterruptedIOException | DoNotRetryIOException e2) {
                    handler.onFailure((IOException)e2);
                }
            }
        });
    }

    static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof LinkageError) {
            throw new DoNotRetryIOException(t);
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)cause;
            }
            t = cause;
            t = AsyncRpcRetryingCaller.translateException(t);
        } else if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        return t;
    }

    private class CallResponseHandler<T>
    implements ResponseHandler<T> {
        private final ResponseHandler<T> handler;
        private final AsyncRetryingCallable<T> callable;
        private final List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        long expectedSleep = 0L;
        int tries = 0;

        public CallResponseHandler(ResponseHandler<T> handler, AsyncRetryingCallable<T> callable) {
            this.handler = handler;
            this.callable = callable;
        }

        @Override
        public void onSuccess(T response) {
            this.handler.onSuccess(response);
        }

        @Override
        public void onFailure(IOException e) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Call exception, tries=" + this.tries + ", retries=" + AsyncRpcRetryingCaller.this.retries + ", retryTime=" + (EnvironmentEdgeManager.currentTimeMillis() - AsyncRpcRetryingCaller.this.globalStartTime) + "ms"), (Throwable)e);
                }
                Throwable t = AsyncRpcRetryingCaller.translateException(e);
                this.callable.throwable(t, AsyncRpcRetryingCaller.this.retries != 1);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, EnvironmentEdgeManager.currentTimeMillis(), this.toString());
                this.exceptions.add(qt);
                ExceptionUtil.rethrowIfInterrupt((Throwable)t);
                if (this.tries >= AsyncRpcRetryingCaller.this.retries - 1) {
                    throw new RetriesExhaustedException(this.tries, this.exceptions);
                }
                this.expectedSleep = this.callable.sleep(AsyncRpcRetryingCaller.this.pause, this.tries + 1);
                long duration = AsyncRpcRetryingCaller.this.singleCallDuration(this.expectedSleep);
                if (duration > (long)AsyncRpcRetryingCaller.this.callTimeout) {
                    String msg = "callTimeout=" + AsyncRpcRetryingCaller.this.callTimeout + ", callDuration=" + duration + ": " + this.callable.getExceptionMessageAdditionalDetail();
                    throw (SocketTimeoutException)new SocketTimeoutException(msg).initCause(t);
                }
            }
            catch (IOException io) {
                this.handler.onFailure(io);
                return;
            }
            AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    try {
                        CallResponseHandler.this.callable.prepare(false);
                    }
                    catch (IOException e2) {
                        CallResponseHandler.this.handler.onFailure(e2);
                        return;
                    }
                    CallResponseHandler.this.callable.call(CallResponseHandler.this);
                }
            }, this.expectedSleep, TimeUnit.MILLISECONDS);
        }
    }
}

