/*
 * Decompiled with CFR 0.152.
 */
package mousio.hbase.async;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import mousio.hbase.async.HbaseResponsePromise;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractHbaseClient;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncClientScanner;
import org.apache.hadoop.hbase.client.AsyncClientSmallReversedScanner;
import org.apache.hadoop.hbase.client.AsyncClientSmallScanner;
import org.apache.hadoop.hbase.client.AsyncResultScanner;
import org.apache.hadoop.hbase.client.AsyncReversedClientScanner;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseClient
extends AbstractHbaseClient
implements Closeable {
    private final AsyncRpcClient client;

    public HbaseClient(HConnection connection) throws IOException {
        super(connection);
        this.client = new AsyncRpcClient(connection, this.clusterId, null);
    }

    public <H extends ResponseHandler<Result>> H get(TableName table, Get get, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, get.getRow(), false);
            this.client.getClientService(location).get((RpcController)this.client.newRpcController(handler), RequestConverter.buildGetRequest((byte[])location.getRegionInfo().getRegionName(), (Get)get), (RpcCallback)new RpcCallback<ClientProtos.GetResponse>(){

                public void run(ClientProtos.GetResponse response) {
                    handler.onSuccess(ProtobufUtil.toResult((ClientProtos.Result)response.getResult()));
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Result[]>> H get(TableName table, List<Get> gets, final H handler) {
        final Result[] results = new Result[gets.size()];
        final AtomicInteger counter = new AtomicInteger(0);
        final AtomicBoolean complete = new AtomicBoolean(false);
        for (int i = 0; i < gets.size(); ++i) {
            this.get(table, gets.get(i), new ResultListener<Result>(i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void onSuccess(Result response) {
                    if (complete.get()) return;
                    Result[] resultArray = results;
                    synchronized (results) {
                        results[this.index] = response;
                        if (counter.incrementAndGet() != results.length) return;
                        handler.onSuccess(results);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                public void onFailure(IOException e) {
                    if (!complete.get()) {
                        handler.onFailure(e);
                        complete.set(true);
                    }
                }
            });
        }
        return handler;
    }

    public AsyncResultScanner getScanner(TableName table, Scan scan) {
        if (scan.isReversed()) {
            if (scan.isSmall()) {
                return new AsyncClientSmallReversedScanner(this.client, scan, table);
            }
            return new AsyncReversedClientScanner(this.client, scan, table);
        }
        if (scan.isSmall()) {
            return new AsyncClientSmallScanner(this.client, scan, table);
        }
        return new AsyncClientScanner(this.client, scan, table);
    }

    public <H extends ResponseHandler<Void>> H put(TableName table, Put put, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, put.getRow(), false);
            this.client.getClientService(location).mutate((RpcController)this.client.newRpcController(handler), RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (Put)put), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    handler.onSuccess(null);
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Void>> H put(TableName table, List<Put> puts, final H handler) {
        final int size = puts.size();
        final AtomicInteger counter = new AtomicInteger(0);
        for (Put put : puts) {
            this.put(table, put, new ResponseHandler<Void>(){

                @Override
                public void onSuccess(Void response) {
                    if (counter.incrementAndGet() == size) {
                        handler.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(IOException e) {
                    if (counter.get() < size) {
                        handler.onFailure(e);
                        counter.set(size);
                    }
                }
            });
        }
        return handler;
    }

    public <H extends ResponseHandler<Boolean>> H checkAndPut(TableName table, byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, put.getRow(), false);
            this.client.getClientService(location).mutate((RpcController)this.client.newRpcController(handler), RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (byte[])row, (byte[])family, (byte[])qualifier, (ByteArrayComparable)new BinaryComparator(value), (HBaseProtos.CompareType)HBaseProtos.CompareType.EQUAL, (Put)put), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    handler.onSuccess(response.getProcessed());
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Void>> H delete(TableName table, Delete delete, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, delete.getRow(), false);
            this.client.getClientService(location).mutate((RpcController)this.client.newRpcController(handler), RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (Delete)delete), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    handler.onSuccess(null);
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Void>> H delete(TableName table, List<Delete> deletes, final H handler) {
        final int size = deletes.size();
        final AtomicInteger counter = new AtomicInteger(0);
        for (Delete delete : deletes) {
            this.delete(table, delete, new ResponseHandler<Void>(){

                @Override
                public void onSuccess(Void response) {
                    if (counter.incrementAndGet() == size) {
                        handler.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(IOException e) {
                    if (counter.get() < size) {
                        handler.onFailure(e);
                        counter.set(size);
                    }
                }
            });
        }
        return handler;
    }

    public <H extends ResponseHandler<Boolean>> H checkAndDelete(TableName table, byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, delete.getRow(), false);
            this.client.getClientService(location).mutate((RpcController)this.client.newRpcController(handler), RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (byte[])row, (byte[])family, (byte[])qualifier, (ByteArrayComparable)new BinaryComparator(value), (HBaseProtos.CompareType)HBaseProtos.CompareType.EQUAL, (Delete)delete), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    handler.onSuccess(response.getProcessed());
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Void>> H mutateRow(TableName table, RowMutations rm, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, rm.getRow(), false);
            ClientProtos.RegionAction.Builder regionMutationBuilder = RequestConverter.buildRegionAction((byte[])location.getRegionInfo().getRegionName(), (RowMutations)rm);
            regionMutationBuilder.setAtomic(true);
            ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(regionMutationBuilder.build()).build();
            this.client.getClientService(location).multi((RpcController)this.client.newRpcController(handler), request, (RpcCallback)new RpcCallback<ClientProtos.MultiResponse>(){

                public void run(ClientProtos.MultiResponse response) {
                    handler.onSuccess(null);
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Result>> H append(TableName table, Append append, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, append.getRow(), false);
            NonceGenerator ng = this.client.getNonceGenerator();
            long nonceGroup = ng.getNonceGroup();
            long nonce = ng.newNonce();
            final AsyncPayloadCarryingRpcController controller = this.client.newRpcController(handler);
            this.client.getClientService(location).mutate((RpcController)controller, RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (Append)append, (long)nonceGroup, (long)nonce), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    try {
                        handler.onSuccess(ProtobufUtil.toResult((ClientProtos.Result)response.getResult(), (CellScanner)controller.cellScanner()));
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Result>> H increment(TableName table, Increment increment, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, increment.getRow(), false);
            NonceGenerator ng = this.client.getNonceGenerator();
            long nonceGroup = ng.getNonceGroup();
            long nonce = ng.newNonce();
            final AsyncPayloadCarryingRpcController controller = this.client.newRpcController(handler);
            this.client.getClientService(location).mutate((RpcController)controller, RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (Increment)increment, (long)nonceGroup, (long)nonce), (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                public void run(ClientProtos.MutateResponse response) {
                    try {
                        handler.onSuccess(ProtobufUtil.toResult((ClientProtos.Result)response.getResult(), (CellScanner)controller.cellScanner()));
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public <H extends ResponseHandler<Long>> H incrementColumnValue(TableName table, byte[] row, byte[] family, byte[] qualifier, long amount, H handler) {
        return this.incrementColumnValue(table, row, family, qualifier, amount, Durability.SYNC_WAL, handler);
    }

    public <H extends ResponseHandler<Long>> H incrementColumnValue(TableName table, byte[] row, final byte[] family, final byte[] qualifier, long amount, Durability durability, final H handler) {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("family is null");
        } else if (qualifier == null) {
            npe = new NullPointerException("qualifier is null");
        }
        if (npe != null) {
            handler.onFailure(new IOException("Invalid arguments to incrementColumnValue", npe));
        } else {
            try {
                HRegionLocation location = this.client.getRegionLocation(table, row, false);
                NonceGenerator ng = this.client.getNonceGenerator();
                long nonceGroup = ng.getNonceGroup();
                long nonce = ng.newNonce();
                ClientProtos.MutateRequest request = RequestConverter.buildIncrementRequest((byte[])location.getRegionInfo().getRegionName(), (byte[])row, (byte[])family, (byte[])qualifier, (long)amount, (Durability)durability, (long)nonceGroup, (long)nonce);
                final AsyncPayloadCarryingRpcController controller = this.client.newRpcController(handler);
                this.client.getClientService(location).mutate((RpcController)controller, request, (RpcCallback)new RpcCallback<ClientProtos.MutateResponse>(){

                    public void run(ClientProtos.MutateResponse response) {
                        try {
                            Result result = ProtobufUtil.toResult((ClientProtos.Result)response.getResult(), (CellScanner)controller.cellScanner());
                            handler.onSuccess(Bytes.toLong((byte[])result.getValue(family, qualifier)));
                        }
                        catch (IOException e) {
                            handler.onFailure(e);
                        }
                    }
                });
            }
            catch (IOException e) {
                handler.onFailure(e);
            }
        }
        return handler;
    }

    public <H extends ResponseHandler<Boolean>> H checkAndMutate(TableName table, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation, final H handler) {
        try {
            HRegionLocation location = this.client.getRegionLocation(table, mutation.getRow(), false);
            this.client.getClientService(location).multi((RpcController)this.client.newRpcController(handler), RequestConverter.buildMutateRequest((byte[])location.getRegionInfo().getRegionName(), (byte[])row, (byte[])family, (byte[])qualifier, (ByteArrayComparable)new BinaryComparator(value), (HBaseProtos.CompareType)HBaseProtos.CompareType.valueOf((String)compareOp.name()), (RowMutations)mutation), (RpcCallback)new RpcCallback<ClientProtos.MultiResponse>(){

                public void run(ClientProtos.MultiResponse response) {
                    handler.onSuccess(response.getProcessed());
                }
            });
        }
        catch (IOException e) {
            handler.onFailure(e);
        }
        return handler;
    }

    public AsyncRpcChannel coprocessorService(TableName table, byte[] row) throws IOException {
        HRegionLocation location = this.client.getRegionLocation(table, row, false);
        return this.client.getConnection(ClientProtos.ClientService.getDescriptor(), location);
    }

    public <T> HbaseResponsePromise<T> newPromise() {
        return new HbaseResponsePromise(this.client.getEventLoop());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public RpcController newRpcController(ResponseHandler<?> promise) {
        return this.client.newRpcController(promise);
    }

    private abstract class ResultListener<R>
    implements ResponseHandler<R> {
        protected int index;

        public ResultListener(int i) {
            this.index = i;
        }
    }
}

