/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.TableName;

public class AsyncPayloadCarryingRpcController
implements RpcController,
CellScannable {
    private int priority = 0;
    private CellScanner cellScanner;
    private boolean cancelled = false;
    private RpcCallback<IOException> exceptionCallback;
    private IOException exception;

    public AsyncPayloadCarryingRpcController() {
        this(null);
    }

    public AsyncPayloadCarryingRpcController(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    public void reset() {
        this.exception = null;
        this.cancelled = false;
        this.exceptionCallback = null;
        this.priority = 0;
        this.cellScanner = null;
    }

    public boolean failed() {
        return this.exception != null;
    }

    public String errorText() {
        return this.exception.getMessage();
    }

    public void startCancel() {
        this.cancelled = true;
    }

    public void setFailed(String reason) {
        this.exception = new IOException(reason);
        if (this.exceptionCallback != null) {
            this.exceptionCallback.run((Object)this.exception);
        }
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void notifyOnCancel(RpcCallback<Object> callback) {
    }

    public void notifyOnError(RpcCallback<IOException> callback) {
        if (this.exception != null) {
            callback.run((Object)this.exception);
        } else {
            this.exceptionCallback = callback;
        }
    }

    public CellScanner cellScanner() {
        return this.cellScanner;
    }

    public void setCellScanner(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPriority(TableName tn) {
        this.priority = tn != null && tn.isSystemTable() ? 100 : 0;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setFailed(IOException e) {
        this.exception = e;
        if (this.exceptionCallback != null) {
            this.exceptionCallback.run((Object)this.exception);
        }
    }
}

