/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.TextFormat;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HbaseCall;
import org.apache.hadoop.hbase.ipc.HbaseResponseHandler;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslClientHandler;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;

public class AsyncRpcChannel
implements RpcChannel {
    public static final Log LOG = LogFactory.getLog((String)AsyncRpcChannel.class.getName());
    private static final byte[] MAGIC = new byte[]{72, 66, 97, 115};
    private static final int MAX_SASL_RETRIES = 5;
    final AsyncRpcClient client;
    private Channel channel;
    private ChannelFuture connectFuture;
    String name;
    final RpcClient.ConnectionId remoteId;
    ConcurrentSkipListMap<Integer, HbaseCall> calls = new ConcurrentSkipListMap();
    int rpcTimeout;
    private int ioFailureCounter = 0;
    private int connectFailureCounter = 0;
    boolean useSasl;
    AuthMethod authMethod;
    private int reloginMaxBackoff;
    private Token<? extends TokenIdentifier> token;
    private String serverPrincipal;
    protected static final Map<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>>();
    public boolean shouldCloseConnection = false;
    private Throwable closeException;
    private Timeout cleanupTimer;

    public AsyncRpcChannel(Bootstrap bootstrap, AsyncRpcClient client, RpcClient.ConnectionId remoteId) {
        this.remoteId = remoteId;
        this.client = client;
        this.name = "IPC Client connection to " + remoteId.getAddress().toString() + (remoteId.getTicket() == null ? " from an unknown user" : " from " + remoteId.getTicket().getName());
        this.connect(bootstrap);
    }

    private void connect(final Bootstrap bootstrap) {
        if (this.client.failedServers.isFailedServer(this.remoteId.getAddress())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not trying to connect to " + this.remoteId.address + " this server is in the failed servers list"));
            }
            RpcClient.FailedServerException e = new RpcClient.FailedServerException("This server is in the failed servers list: " + this.remoteId.address);
            this.close((Throwable)e);
            return;
        }
        this.connectFuture = bootstrap.remoteAddress((SocketAddress)this.remoteId.address).connect().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (AsyncRpcChannel.this.closeException instanceof SocketException) {
                        AsyncRpcChannel.this.retryOrClose(bootstrap, AsyncRpcChannel.this.connectFailureCounter++, AsyncRpcChannel.this.closeException);
                    } else {
                        AsyncRpcChannel.this.retryOrClose(bootstrap, AsyncRpcChannel.this.ioFailureCounter++, AsyncRpcChannel.this.closeException);
                    }
                    return;
                }
                AsyncRpcChannel.this.setupAuthorization();
                if (AsyncRpcChannel.this.useSasl) {
                    UserGroupInformation ticket = AsyncRpcChannel.this.remoteId.getTicket().getUGI();
                    if (AsyncRpcChannel.this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                        ticket = ticket.getRealUser();
                    }
                    if (ticket == null) {
                        throw new FatalConnectionException("ticket/user is null");
                    }
                    SaslClientHandler saslHandler = (SaslClientHandler)((Object)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslClientHandler>(){

                        @Override
                        public SaslClientHandler run() throws IOException {
                            return AsyncRpcChannel.this.getSaslHandler(bootstrap);
                        }
                    }));
                    if (saslHandler != null) {
                        f.channel().pipeline().addLast(new ChannelHandler[]{saslHandler});
                    } else {
                        AsyncRpcChannel.this.authMethod = AuthMethod.SIMPLE;
                        AsyncRpcChannel.this.useSasl = false;
                    }
                }
                f.channel().pipeline().addLast(new ChannelHandler[]{new HbaseResponseHandler(AsyncRpcChannel.this)});
                AsyncRpcChannel.this.writeChannelHeader(f.channel()).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        AsyncRpcChannel.this.connectFuture = null;
                        AsyncRpcChannel.this.channel = future.channel();
                        AsyncRpcChannel.this.sendRequestsAfterConnect(AsyncRpcChannel.this.channel);
                    }
                });
                AsyncRpcChannel.this.name = "IPC Client (" + AsyncRpcChannel.this.channel.hashCode() + ") connection to " + AsyncRpcChannel.this.remoteId.getAddress().toString() + (AsyncRpcChannel.this.remoteId.ticket == null ? " from an unknown user" : " from " + AsyncRpcChannel.this.remoteId.ticket.getName());
            }
        });
    }

    private SaslClientHandler getSaslHandler(final Bootstrap bootstrap) throws IOException {
        return new SaslClientHandler(this.authMethod, this.token, this.serverPrincipal, this.client.fallbackAllowed, this.client.configuration.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()), new SaslClientHandler.SaslExceptionHandler(){

            @Override
            public void handle(int retryCount, Random random, Throwable cause) {
                try {
                    AsyncRpcChannel.this.handleSaslConnectionFailure(retryCount, cause, AsyncRpcChannel.this.remoteId.getTicket().getUGI());
                    AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) throws Exception {
                            AsyncRpcChannel.this.connect(bootstrap);
                        }
                    }, (long)(random.nextInt(AsyncRpcChannel.this.reloginMaxBackoff) + 1), TimeUnit.MILLISECONDS);
                }
                catch (IOException | InterruptedException e) {
                    AsyncRpcChannel.this.close(e);
                }
            }
        });
    }

    private void retryOrClose(final Bootstrap bootstrap, int connectCounter, Throwable e) {
        if (connectCounter < this.client.maxRetries) {
            AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    AsyncRpcChannel.this.connect(bootstrap);
                }
            }, this.client.failureSleep, TimeUnit.MILLISECONDS);
        } else {
            this.client.failedServers.addToFailedServers(this.remoteId.address);
            this.close(e);
        }
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        HbaseCall call = new HbaseCall(method, request, (AsyncPayloadCarryingRpcController)controller, responsePrototype, done);
        this.calls.put(call.id, call);
        if (this.channel != null) {
            this.writeRequest(this.channel, call);
        }
    }

    private void sendRequestsAfterConnect(Channel channel) {
        for (HbaseCall call : this.calls.values()) {
            this.writeRequest(channel, call);
        }
    }

    private ChannelFuture writeChannelHeader(Channel channel) throws IOException {
        RPCProtos.ConnectionHeader.Builder headerBuilder = RPCProtos.ConnectionHeader.newBuilder().setServiceName(ClientProtos.ClientService.getDescriptor().getName());
        RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
        builder.setServiceName(this.remoteId.serviceName);
        RPCProtos.UserInformation userInfoPB = this.buildUserInfo(this.remoteId.getTicket().getUGI(), this.authMethod);
        if (userInfoPB != null) {
            headerBuilder.setUserInfo(userInfoPB);
        }
        if (this.client.codec != null) {
            headerBuilder.setCellBlockCodecClass(this.client.codec.getClass().getCanonicalName());
        }
        if (this.client.compressor != null) {
            headerBuilder.setCellBlockCompressorClass(this.client.compressor.getClass().getCanonicalName());
        }
        RPCProtos.ConnectionHeader header = headerBuilder.build();
        ByteBuf b = channel.alloc().buffer(6 + IPCUtil.getTotalSizeWhenWrittenDelimited((Message[])new Message[]{header}));
        this.createPreamble(b, this.authMethod);
        b.writeInt(header.getSerializedSize());
        b.writeBytes(header.toByteArray());
        return channel.writeAndFlush((Object)b);
    }

    private void writeRequest(Channel channel, HbaseCall call) {
        block21: {
            try {
                ByteBuffer cellBlock;
                if (this.shouldCloseConnection) {
                    return;
                }
                RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder().setCallId(call.id).setMethodName(call.method.getName()).setRequestParam(call.param != null);
                if (Trace.isTracing()) {
                    Span s = Trace.currentSpan();
                    builder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(s.getSpanId()).setTraceId(s.getTraceId()));
                }
                if ((cellBlock = this.client.buildCellBlock(call.controller.cellScanner())) != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(cellBlock.limit());
                    builder.setCellBlockMeta(cellBlockBuilder.build());
                }
                if (call.controller.getPriority() != 0) {
                    builder.setPriority(call.controller.getPriority());
                }
                RPCProtos.RequestHeader rh = builder.build();
                int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited((Message[])new Message[]{rh, call.param});
                if (cellBlock != null) {
                    totalSize += cellBlock.remaining();
                }
                ByteBuf b = channel.alloc().buffer(totalSize);
                try (ByteBufOutputStream out = new ByteBufOutputStream(b);){
                    IPCUtil.write((OutputStream)out, (Message)rh, (Message)call.param, (ByteBuffer)cellBlock);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ": wrote request header " + TextFormat.shortDebugString((MessageOrBuilder)rh)));
                }
                channel.writeAndFlush((Object)b);
            }
            catch (IOException e) {
                if (this.shouldCloseConnection) break block21;
                this.close(e);
            }
        }
    }

    private void setupAuthorization() throws IOException {
        SecurityInfo securityInfo = SecurityInfo.getInfo((String)this.remoteId.serviceName);
        this.useSasl = this.client.userProvider.isHBaseSecurityEnabled();
        this.token = null;
        if (this.useSasl && securityInfo != null) {
            String serverKey;
            AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
            if (tokenKind != null) {
                TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenKind);
                if (tokenSelector != null) {
                    this.token = tokenSelector.selectToken(new Text(this.client.clusterId), this.remoteId.getTicket().getUGI().getTokens());
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No token selector found for type " + tokenKind));
                }
            }
            if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
            }
            this.serverPrincipal = SecurityUtil.getServerPrincipal((String)this.client.configuration.get(serverKey), (String)this.remoteId.address.getAddress().getCanonicalHostName().toLowerCase());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RPC Server Kerberos principal name for service=" + this.remoteId.serviceName + " is " + this.serverPrincipal));
            }
        }
        this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Use " + this.authMethod + " authentication for service " + this.remoteId.serviceName + ", sasl=" + this.useSasl));
        }
        this.reloginMaxBackoff = this.client.configuration.getInt("hbase.security.relogin.maxbackoff", 5000);
    }

    private RPCProtos.UserInformation buildUserInfo(UserGroupInformation ugi, AuthMethod authMethod) {
        if (ugi == null || authMethod == AuthMethod.DIGEST) {
            return null;
        }
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        if (authMethod == AuthMethod.KERBEROS) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
        } else if (authMethod == AuthMethod.SIMPLE) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
            if (ugi.getRealUser() != null) {
                userInfoPB.setRealUser(ugi.getRealUser().getUserName());
            }
        }
        return userInfoPB.build();
    }

    private void createPreamble(ByteBuf byteBuf, AuthMethod authMethod) {
        byteBuf.writeBytes(MAGIC);
        byteBuf.writeByte(0);
        byteBuf.writeByte((int)authMethod.code);
    }

    public void close(Throwable e) {
        if (!this.shouldCloseConnection) {
            this.shouldCloseConnection = true;
            this.closeException = e;
            this.client.removeConnection(this.remoteId);
            if (this.channel != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ": closing ipc connection to " + this.channel.remoteAddress() + ": " + this.closeException.getMessage()), this.closeException);
                }
                if (!this.channel.isOpen()) {
                    this.channel.close();
                }
            } else if (this.connectFuture != null) {
                this.connectFuture.cancel(true);
            }
            this.cleanupTimedOutCalls(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + ": closed"));
            }
        }
    }

    public void cleanupTimedOutCalls(int rpcTimeout) {
        if (this.cleanupTimer != null) {
            this.cleanupTimer.cancel();
            this.cleanupTimer = null;
        }
        for (HbaseCall call : this.calls.values()) {
            long waitTime = System.currentTimeMillis() - call.getStartTime();
            if (waitTime < (long)rpcTimeout) break;
            this.closeException = new RpcClient.CallTimeoutException("Call id=" + call.id + ", waitTime=" + waitTime + ", rpcTimeout=" + rpcTimeout);
            call.setFailed((IOException)this.closeException);
            this.calls.remove(call.id);
        }
        if (!this.calls.isEmpty()) {
            HbaseCall firstCall = this.calls.firstEntry().getValue();
            long maxWaitTime = System.currentTimeMillis() - firstCall.getStartTime();
            if (maxWaitTime < (long)rpcTimeout) {
                rpcTimeout = (int)((long)rpcTimeout - maxWaitTime);
            }
        }
        if (!this.shouldCloseConnection) {
            this.closeException = null;
            this.cleanupTimer = AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    AsyncRpcChannel.this.cleanupTimer = null;
                    AsyncRpcChannel.this.cleanupTimedOutCalls(AsyncRpcChannel.this.rpcTimeout);
                }
            }, (long)rpcTimeout, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isAlive() {
        return this.channel != null && (this.channel.isOpen() || this.channel.isActive());
    }

    private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = currentUser.getRealUser();
        return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
    }

    private void handleSaslConnectionFailure(final int currRetries, final Throwable ex, UserGroupInformation user) throws IOException, InterruptedException {
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                if (AsyncRpcChannel.this.shouldAuthenticateOverKrb()) {
                    if (currRetries < 5) {
                        LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                        if (UserGroupInformation.isLoginKeytabBased()) {
                            UserGroupInformation.getLoginUser().reloginFromKeytab();
                        } else {
                            UserGroupInformation.getLoginUser().reloginFromTicketCache();
                        }
                        return null;
                    }
                    String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + AsyncRpcChannel.this.serverPrincipal;
                    LOG.warn((Object)msg);
                    throw (IOException)new IOException(msg).initCause(ex);
                }
                LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                if (ex instanceof SaslException) {
                    String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                    LOG.fatal((Object)msg, ex);
                    throw new RuntimeException(msg, ex);
                }
                throw new IOException(ex);
            }
        });
    }

    static {
        tokenHandlers.put(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, (TokenSelector<? extends TokenIdentifier>)new AuthenticationTokenSelector());
    }
}

