/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

public class HbaseCall {
    public static final Log LOG = LogFactory.getLog((String)HbaseCall.class.getName());
    private static int idCounter = 0;
    final int id;
    final Descriptors.MethodDescriptor method;
    final Message param;
    final AsyncPayloadCarryingRpcController controller;
    final Message responseDefaultType;
    final long startTime;
    private final RpcCallback<Message> doneHandler;

    public HbaseCall(Descriptors.MethodDescriptor md, Message param, AsyncPayloadCarryingRpcController controller, Message responseDefaultType, RpcCallback<Message> doneHandler) {
        this.method = md;
        this.param = param;
        this.controller = controller;
        this.responseDefaultType = responseDefaultType;
        this.startTime = System.currentTimeMillis();
        this.id = idCounter++;
        this.doneHandler = doneHandler;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "callId: " + this.id + " methodName: " + this.method.getName() + " param {" + (this.param != null ? ProtobufUtil.getShortTextFormat((Message)this.param) : "") + "}";
    }

    public void setSuccess(Message value, CellScanner cellBlockScanner) {
        if (cellBlockScanner != null) {
            this.controller.setCellScanner(cellBlockScanner);
        }
        if (LOG.isTraceEnabled()) {
            long callTime = System.currentTimeMillis() - this.startTime;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Call: " + this.method.getName() + ", callTime: " + callTime + "ms"));
            }
        }
        this.doneHandler.run((Object)value);
    }

    public void setFailed(IOException exception) {
        if (ExceptionUtil.isInterrupt((Throwable)exception)) {
            exception = ExceptionUtil.asInterrupt((Throwable)exception);
        }
        if (exception instanceof RemoteException) {
            exception = ((RemoteException)exception).unwrapRemoteException();
        }
        this.controller.setFailed(exception);
    }
}

