/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncResultScanner;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hadoop.hbase.client.AsyncScannerCallable;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AsyncClientScanner
implements AsyncResultScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    final AsyncRpcClient client;
    protected Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected AsyncScannerCallable callable = null;
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final TableName tableName;
    protected final int scannerTimeout;
    protected boolean scanMetricsPublished = false;
    protected AsyncRpcRetryingCaller<Result[]> caller;
    protected ScanMetrics scanMetrics;
    private boolean scanIsDone;

    protected void initScanMetrics(Scan scan) {
        byte[] enableMetrics = scan.getAttribute("scan.attributes.metrics.enable");
        if (enableMetrics != null && Bytes.toBoolean((byte[])enableMetrics)) {
            this.scanMetrics = new ScanMetrics();
        }
    }

    protected ScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }

    public AsyncClientScanner(AsyncRpcClient client, Scan scan, TableName tableName) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary((byte[])scan.getStartRow())));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.client = client;
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : client.getConfiguration().getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.scannerTimeout = client.getConfiguration().getInt(HConstants.HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD);
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : client.getConfiguration().getInt(HConstants.HBASE_CLIENT_SCANNER_CACHING, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_CACHING);
        this.caller = new AsyncRpcRetryingCaller(client.getConfiguration().getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE), client.getConfiguration().getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER));
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    protected boolean checkScanStopRow(byte[] endKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo((byte[])(stopRow = this.scan.getStopRow()), (int)0, (int)stopRow.length, (byte[])endKey, (int)0, (int)endKey.length)) <= 0;
    }

    protected void nextScanner(int nbRows, boolean done, final ResponseHandler<Boolean> handler) {
        byte[] localStartKey;
        if (this.checkToCloseScanner(nbRows, done, handler)) {
            return;
        }
        if (this.currentRegion != null) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace((Object)("Finished " + this.currentRegion));
                }
                this.setScanDone();
                handler.onSuccess(false);
            }
            localStartKey = endKey;
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isDebugEnabled() && this.currentRegion != null) {
            this.LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.callable = this.getScannerCallable(localStartKey, nbRows);
        this.caller.callWithRetries(this.callable, new ResponseHandler<Result[]>(){

            @Override
            public void onSuccess(Result[] response) {
                AsyncClientScanner.this.currentRegion = AsyncClientScanner.this.callable.getHRegionInfo();
                if (AsyncClientScanner.this.scanMetrics != null) {
                    AsyncClientScanner.this.scanMetrics.countOfRegions.incrementAndGet();
                }
                handler.onSuccess(true);
            }

            @Override
            public void onFailure(IOException e) {
                AsyncClientScanner.this.close();
                handler.onFailure(e);
            }
        });
    }

    boolean checkToCloseScanner(final int nbRows, final boolean done, final ResponseHandler<Boolean> handler) {
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithRetries(this.callable, new ResponseHandler<Result[]>(){

                @Override
                public void onSuccess(Result[] response) {
                    AsyncClientScanner.this.callable = null;
                    AsyncClientScanner.this.nextScanner(nbRows, done, handler);
                }

                @Override
                public void onFailure(IOException e) {
                    handler.onFailure(e);
                }
            });
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    protected AsyncScannerCallable getScannerCallable(byte[] localStartKey, int nbRows) {
        this.scan.setStartRow(localStartKey);
        AsyncScannerCallable s = new AsyncScannerCallable(this.client, this.getTable(), this.scan, this.scanMetrics, new AsyncPayloadCarryingRpcController());
        s.setMaxResults(nbRows);
        return s;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        MapReduceProtos.ScanMetrics pScanMetrics = ProtobufUtil.toScanMetrics((ScanMetrics)this.scanMetrics);
        this.scan.setAttribute("scan.attributes.metrics.data", pScanMetrics.toByteArray());
        this.scanMetricsPublished = true;
    }

    @Override
    public <H extends ResponseHandler<Result[]>> H nextBatch(final H handler) {
        if (this.callable == null) {
            this.nextScanner(this.caching, false, new ResponseHandler<Boolean>(){

                @Override
                public void onSuccess(Boolean response) {
                    AsyncClientScanner.this.nextBatch(handler);
                }

                @Override
                public void onFailure(IOException e) {
                    handler.onFailure(e);
                }
            });
        } else {
            this.callable.setMaxResults(this.caching);
            this.caller.callWithRetries(this.callable, new RetryingResponseHandler(handler, this.maxScannerResultSize, this.caching));
        }
        return handler;
    }

    @Override
    public boolean isScanDone() {
        return this.scanIsDone;
    }

    protected void setScanDone() {
        this.scanIsDone = true;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            this.caller.callWithRetries(this.callable, new ResponseHandler<Result[]>(){

                @Override
                public void onSuccess(Result[] response) {
                    AsyncClientScanner.this.callable = null;
                    AsyncClientScanner.this.closed = true;
                }

                @Override
                public void onFailure(IOException e) {
                    if (e instanceof UnknownScannerException) {
                        return;
                    }
                    if (e != null) {
                        AsyncClientScanner.this.LOG.warn((Object)("scanner failed to close. Exception follows: " + e));
                    }
                    AsyncClientScanner.this.callable = null;
                    AsyncClientScanner.this.closed = true;
                }
            });
        }
    }

    private class RetryingResponseHandler
    implements ResponseHandler<Result[]> {
        private final ResponseHandler<Result[]> handler;
        private long remainingResultSize;
        private int countdown;
        boolean retryAfterOutOfOrderException = true;
        protected final LinkedList<Result> cache = new LinkedList();

        public RetryingResponseHandler(ResponseHandler<Result[]> handler, long maxScannerResultSize, int caching) {
            this.handler = handler;
            this.remainingResultSize = maxScannerResultSize;
            this.countdown = caching;
        }

        @Override
        public void onSuccess(Result[] values) {
            this.retryAfterOutOfOrderException = true;
            long currentTime = System.currentTimeMillis();
            if (AsyncClientScanner.this.scanMetrics != null) {
                AsyncClientScanner.this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - AsyncClientScanner.this.lastNext);
            }
            AsyncClientScanner.this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (Result rs : values) {
                    this.cache.add(rs);
                    --this.remainingResultSize;
                    --this.countdown;
                    AsyncClientScanner.this.lastResult = rs;
                }
            }
            this.tryAgain(values);
        }

        private void tryAgain(Result[] values) {
            if (this.remainingResultSize > 0L && this.countdown > 0) {
                AsyncClientScanner.this.nextScanner(this.countdown, values == null, new ResponseHandler<Boolean>(){

                    @Override
                    public void onSuccess(Boolean doContinue) {
                        if (doContinue.booleanValue()) {
                            AsyncClientScanner.this.caller.callWithRetries(AsyncClientScanner.this.callable, RetryingResponseHandler.this);
                        } else {
                            RetryingResponseHandler.this.handler.onSuccess(RetryingResponseHandler.this.cache.toArray(new Result[RetryingResponseHandler.this.cache.size()]));
                            RetryingResponseHandler.this.cache.clear();
                            AsyncClientScanner.this.writeScanMetrics();
                        }
                    }

                    @Override
                    public void onFailure(IOException e) {
                        RetryingResponseHandler.this.handler.onFailure(e);
                    }
                });
            } else {
                if (this.remainingResultSize == 0L) {
                    AsyncClientScanner.this.setScanDone();
                }
                this.handler.onSuccess(this.cache.toArray(new Result[this.cache.size()]));
                this.cache.clear();
                AsyncClientScanner.this.writeScanMetrics();
            }
        }

        @Override
        public void onFailure(IOException e) {
            if (e instanceof DoNotRetryIOException) {
                if (e instanceof UnknownScannerException) {
                    long timeout = AsyncClientScanner.this.lastNext + (long)AsyncClientScanner.this.scannerTimeout;
                    if (timeout < System.currentTimeMillis()) {
                        long elapsed = System.currentTimeMillis() - AsyncClientScanner.this.lastNext;
                        ScannerTimeoutException ex = new ScannerTimeoutException(elapsed + "ms passed since the last invocation, " + "timeout is currently set to " + AsyncClientScanner.this.scannerTimeout);
                        ex.initCause((Throwable)e);
                        this.handler.onFailure(e);
                    }
                } else {
                    Throwable cause = e.getCause();
                    if (!(cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException)) {
                        this.handler.onFailure(e);
                    }
                }
                if (AsyncClientScanner.this.lastResult != null) {
                    AsyncClientScanner.this.scan.setStartRow(AsyncClientScanner.this.lastResult.getRow());
                    byte[] newStart = new byte[AsyncClientScanner.this.lastResult.getRow().length + 1];
                    System.arraycopy(AsyncClientScanner.this.lastResult.getRow(), 0, newStart, 0, newStart.length - 1);
                    newStart[newStart.length - 1] = 0;
                    AsyncClientScanner.this.scan.setStartRow(newStart);
                }
                if (e instanceof OutOfOrderScannerNextException) {
                    if (this.retryAfterOutOfOrderException) {
                        this.retryAfterOutOfOrderException = false;
                    } else {
                        this.handler.onFailure((IOException)new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", (Throwable)e));
                    }
                }
                AsyncClientScanner.this.currentRegion = null;
                AsyncClientScanner.this.callable = null;
                this.tryAgain(null);
            }
        }
    }
}

