/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncRegionServerCallable;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Private
public class AsyncScannerCallable
extends AsyncRegionServerCallable<Result[]> {
    static final Log LOG = LogFactory.getLog(AsyncScannerCallable.class);
    private long scannerId = -1L;
    protected boolean instantiated = false;
    private boolean closed = false;
    private final Scan scan;
    private int maxResults = 1;
    protected ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    private static String myAddress;
    protected boolean isRegionServerRemote = true;
    private long nextCallSeq = 0L;
    protected final AsyncPayloadCarryingRpcController controller;

    public AsyncScannerCallable(AsyncRpcClient client, TableName tableName, Scan scan, ScanMetrics scanMetrics, AsyncPayloadCarryingRpcController controller) {
        super(client, tableName, scan.getStartRow());
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = client.getConfiguration();
        this.logScannerActivity = conf.getBoolean("hbase.client.log.scanner.activity", false);
        this.logCutOffLatency = conf.getInt("hbase.client.log.scanner.latency.cutoff", 1000);
        this.controller = controller;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            super.prepare(reload);
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    protected void checkIfRegionServerIsRemote() {
        this.isRegionServerRemote = !this.location.getHostname().equalsIgnoreCase(myAddress);
    }

    @Override
    public void call(final ResponseHandler<Result[]> handler) {
        if (this.closed) {
            if (this.scannerId != -1L) {
                this.close(handler);
            }
        } else if (this.scannerId == -1L) {
            this.openScanner(new ResponseHandler<Long>(){

                @Override
                public void onSuccess(Long response) {
                    AsyncScannerCallable.this.scannerId = response;
                    handler.onSuccess(null);
                }

                @Override
                public void onFailure(IOException e) {
                    handler.onFailure(e);
                }
            });
        } else {
            this.incRPCcallsMetrics();
            final ClientProtos.ScanRequest request = RequestConverter.buildScanRequest((long)this.scannerId, (int)this.maxResults, (boolean)false, (long)this.nextCallSeq);
            this.controller.setPriority(this.tableName);
            this.controller.notifyOnError(new RpcCallback<IOException>(){

                public void run(IOException e) {
                    if (AsyncScannerCallable.this.logScannerActivity) {
                        LOG.info((Object)("Got exception making request " + TextFormat.shortDebugString((MessageOrBuilder)request) + " to " + AsyncScannerCallable.this.location), (Throwable)e);
                    }
                    if (e instanceof RemoteException) {
                        try {
                            e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((RemoteException)e));
                        }
                        catch (IOException e1) {
                            handler.onFailure(e1);
                            return;
                        }
                    }
                    if (AsyncScannerCallable.this.logScannerActivity && e instanceof UnknownScannerException) {
                        try {
                            HRegionLocation newLocation = AsyncScannerCallable.this.client.getHConnection().relocateRegion(AsyncScannerCallable.this.tableName, AsyncScannerCallable.this.row);
                            LOG.info((Object)("Scanner=" + AsyncScannerCallable.this.scannerId + " expired, current region location is " + newLocation.toString()));
                        }
                        catch (Throwable t) {
                            LOG.info((Object)"Failed to relocate region", t);
                        }
                    }
                    if (e instanceof NotServingRegionException) {
                        if (AsyncScannerCallable.this.scanMetrics != null) {
                            AsyncScannerCallable.this.scanMetrics.countOfNSRE.incrementAndGet();
                        }
                        handler.onFailure((IOException)((Object)new DoNotRetryIOException("Resetting the scanner -- see exception cause", (Throwable)e)));
                    } else if (e instanceof RegionServerStoppedException) {
                        handler.onFailure((IOException)((Object)new DoNotRetryIOException("Resetting the scanner -- see exception cause", (Throwable)e)));
                    } else {
                        handler.onFailure(e);
                    }
                }
            });
            this.getStub().scan((RpcController)this.controller, request, (RpcCallback)new RpcCallback<ClientProtos.ScanResponse>(){

                public void run(ClientProtos.ScanResponse response) {
                    AsyncScannerCallable.this.nextCallSeq++;
                    long timestamp = System.currentTimeMillis();
                    CellScanner cellScanner = AsyncScannerCallable.this.controller.cellScanner();
                    try {
                        long now;
                        Result[] rrs = ResponseConverter.getResults((CellScanner)cellScanner, (ClientProtos.ScanResponse)response);
                        if (AsyncScannerCallable.this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)AsyncScannerCallable.this.logCutOffLatency) {
                            int rows = rrs == null ? 0 : rrs.length;
                            LOG.info((Object)("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + AsyncScannerCallable.this.scannerId));
                        }
                        if (response.hasMoreResults() && !response.getMoreResults()) {
                            AsyncScannerCallable.this.scannerId = -1L;
                            AsyncScannerCallable.this.closed = true;
                            rrs = null;
                        }
                        AsyncScannerCallable.this.updateResultsMetrics(rrs);
                        handler.onSuccess(rrs);
                    }
                    catch (IOException e) {
                        handler.onFailure(e);
                    }
                }
            });
        }
    }

    private void incRPCcallsMetrics() {
        if (this.scanMetrics == null) {
            return;
        }
        this.scanMetrics.countOfRPCcalls.incrementAndGet();
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    private void updateResultsMetrics(Result[] rrs) {
        if (this.scanMetrics == null || rrs == null || rrs.length == 0) {
            return;
        }
        long resultSize = 0L;
        for (Result rr : rrs) {
            for (Cell kv : rr.rawCells()) {
                resultSize += (long)CellUtil.estimatedSizeOf((Cell)kv);
            }
        }
        this.scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfBytesInRemoteResults.addAndGet(resultSize);
        }
    }

    private void close(final ResponseHandler<Result[]> handler) {
        if (this.scannerId == -1L) {
            return;
        }
        this.incRPCcallsMetrics();
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest((long)this.scannerId, (int)0, (boolean)true);
        final ResponseHandler<Result[]> handlerInternal = new ResponseHandler<Result[]>(){

            @Override
            public void onSuccess(Result[] response) {
                AsyncScannerCallable.this.scannerId = -1L;
                AsyncScannerCallable.this.closed = true;
                handler.onSuccess(response);
            }

            @Override
            public void onFailure(IOException e) {
                handler.onFailure(e);
            }
        };
        this.getStub().scan((RpcController)this.client.newRpcController(handlerInternal), request, (RpcCallback)new RpcCallback<ClientProtos.ScanResponse>(){

            public void run(ClientProtos.ScanResponse parameter) {
                handlerInternal.onSuccess(null);
            }
        });
    }

    protected void openScanner(final ResponseHandler<Long> responseHandler) {
        this.incRPCcallsMetrics();
        try {
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest((byte[])this.location.getRegionInfo().getRegionName(), (Scan)this.scan, (int)0, (boolean)false);
            final ResponseHandler<ClientProtos.ScanResponse> handler = new ResponseHandler<ClientProtos.ScanResponse>(){

                @Override
                public void onSuccess(ClientProtos.ScanResponse response) {
                    long id = response.getScannerId();
                    if (AsyncScannerCallable.this.logScannerActivity) {
                        LOG.info((Object)("Open scanner=" + id + " for scan=" + AsyncScannerCallable.this.scan.toString() + " on region " + AsyncScannerCallable.this.location.toString()));
                    }
                    responseHandler.onSuccess(id);
                }

                @Override
                public void onFailure(IOException e) {
                    responseHandler.onFailure(e);
                }
            };
            this.getStub().scan((RpcController)this.client.newRpcController(handler), request, (RpcCallback)new RpcCallback<ClientProtos.ScanResponse>(){

                public void run(ClientProtos.ScanResponse response) {
                    handler.onSuccess(response);
                }
            });
        }
        catch (IOException e) {
            responseHandler.onFailure(e);
        }
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.location.getRegionInfo();
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    static {
        try {
            myAddress = DNS.getDefaultHost((String)"default", (String)"default");
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"cannot determine my address", (Throwable)uhe);
        }
    }
}

