/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.compress.CompressionCodec;

public class AsyncRpcClient {
    public static final Log LOG = LogFactory.getLog((String)AsyncRpcClient.class.getName());
    private final HConnection connection;
    protected final Configuration configuration;
    private final NioEventLoopGroup eventLoopGroup;
    private final PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> connections;
    public final IPCUtil ipcUtil;
    final UserProvider userProvider;
    final String clusterId;
    final RpcClient.FailedServers failedServers;
    private final Bootstrap bootstrap;
    public final Codec codec;
    public final CompressionCodec compressor;
    final boolean fallbackAllowed;
    final int maxRetries;
    final long failureSleep;
    final int rpcTimeout;
    final int maxIdleTime;
    public static final HashedWheelTimer WHEEL_TIMER = new HashedWheelTimer(100L, TimeUnit.MILLISECONDS);

    public AsyncRpcClient(HConnection connection, String clusterId, SocketAddress localAddress) {
        LOG.info((Object)"Setting up Hbase Netty client");
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.ipcUtil = new IPCUtil(this.configuration);
        this.codec = this.getCodec(this.configuration);
        this.compressor = AsyncRpcClient.getCompressor(this.configuration);
        this.clusterId = clusterId != null ? clusterId : "default-cluster";
        this.rpcTimeout = this.configuration.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
        this.eventLoopGroup = new NioEventLoopGroup();
        this.maxIdleTime = this.configuration.getInt("hbase.ipc.client.connection.maxidletime", 10000);
        this.maxRetries = this.configuration.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = this.configuration.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        boolean tcpKeepAlive = this.configuration.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        boolean tcpNoDelay = this.configuration.getBoolean("hbase.ipc.client.tcpnodelay", true);
        final int pingInterval = RpcClient.getPingInterval((Configuration)this.configuration);
        this.connections = new PoolMap(RpcClient.getPoolType((Configuration)this.configuration), RpcClient.getPoolSize((Configuration)this.configuration));
        this.failedServers = new RpcClient.FailedServers(this.configuration);
        this.fallbackAllowed = this.configuration.getBoolean("hbase.ipc.client.fallback-to-simple-auth-allowed", false);
        this.userProvider = UserProvider.instantiate((Configuration)this.configuration);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Codec=" + this.codec + ", compressor=" + this.compressor + ", tcpKeepAlive=" + tcpKeepAlive + ", tcpNoDelay=" + tcpNoDelay + ", maxIdleTime=" + this.maxIdleTime + ", maxRetries=" + this.maxRetries + ", fallbackAllowed=" + this.fallbackAllowed + ", bind address=" + (localAddress != null ? localAddress : "null")));
        }
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay)).option(ChannelOption.SO_KEEPALIVE, (Object)tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE))).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(pingInterval, AsyncRpcClient.this.maxIdleTime, 0));
                p.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4));
            }
        });
        if (localAddress != null) {
            this.bootstrap.localAddress(localAddress);
        }
    }

    Codec getCodec(Configuration configuration) {
        String className = configuration.get("hbase.client.rpc.codec", RpcClient.getDefaultCodec((Configuration)configuration));
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (Codec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting codec " + className, e);
        }
    }

    private static CompressionCodec getCompressor(Configuration conf) {
        String className = conf.get("hbase.client.rpc.compressor", null);
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (CompressionCodec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting compressor " + className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping async rpc client");
        }
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            for (AsyncRpcChannel conn : this.connections.values()) {
                conn.close(new InterruptedException("Closing Async RPC client"));
            }
        }
        this.eventLoopGroup.shutdownGracefully();
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public EventExecutor getEventLoop() {
        return this.eventLoopGroup.next();
    }

    public CellScanner createCellScanner(byte[] cellBlock) throws IOException {
        return this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
    }

    public ByteBuffer buildCellBlock(CellScanner cells) throws IOException {
        return this.ipcUtil.buildCellBlock(this.codec, this.compressor, cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnections(String hostname, int port, IOException ioe) {
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            for (AsyncRpcChannel rpcChannel : this.connections.values()) {
                if (!rpcChannel.isAlive() || rpcChannel.remoteId.address.getPort() != port || !rpcChannel.remoteId.address.getHostName().equals(hostname)) continue;
                LOG.info((Object)("The server on " + hostname + ":" + port + " is dead - stopping the connection " + rpcChannel.remoteId));
                rpcChannel.close(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncRpcChannel getConnection(Descriptors.ServiceDescriptor serviceDescriptor, HRegionLocation location) throws IOException {
        AsyncRpcChannel rpcChannel;
        if (this.eventLoopGroup.isShuttingDown() || this.eventLoopGroup.isShutdown()) {
            throw new StoppedRpcClientException();
        }
        RpcClient.ConnectionId remoteId = new RpcClient.ConnectionId(this.userProvider.getCurrent(), serviceDescriptor.getName(), new InetSocketAddress(location.getHostname(), location.getPort()), this.rpcTimeout);
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            rpcChannel = (AsyncRpcChannel)this.connections.get((Object)remoteId);
            if (rpcChannel == null) {
                rpcChannel = new AsyncRpcChannel(this.bootstrap, this, remoteId);
                this.connections.put((Object)remoteId, (Object)rpcChannel);
            }
        }
        return rpcChannel;
    }

    public void removeConnection(RpcClient.ConnectionId remoteId) {
        this.connections.remove((Object)remoteId);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HRegionLocation getRegionLocation(TableName table, byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(table, row, reload);
    }

    public NonceGenerator getNonceGenerator() {
        return this.connection.getNonceGenerator();
    }

    public <T> AsyncPayloadCarryingRpcController newRpcController(final ResponseHandler<T> handler) {
        AsyncPayloadCarryingRpcController controller = new AsyncPayloadCarryingRpcController();
        controller.notifyOnError(new RpcCallback<IOException>(){

            public void run(IOException e) {
                handler.onFailure(e);
            }
        });
        return controller;
    }

    public ClientProtos.ClientService.Interface getClientService(HRegionLocation location) throws IOException {
        return ClientProtos.ClientService.newStub((RpcChannel)this.getConnection(ClientProtos.ClientService.getDescriptor(), location));
    }

    public HConnection getHConnection() {
        return this.connection;
    }
}

