/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseCall;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.ipc.RemoteException;

public class HBaseResponseHandler
extends ChannelInboundHandlerAdapter {
    public static final Log LOG = LogFactory.getLog((String)HBaseResponseHandler.class.getName());
    private final AsyncRpcChannel channel;

    public HBaseResponseHandler(AsyncRpcChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf inBuffer = (ByteBuf)msg;
        ByteBufInputStream in = new ByteBufInputStream(inBuffer);
        if (this.channel.shouldCloseConnection) {
            return;
        }
        int totalSize = -1;
        try {
            HBaseCall call;
            RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)in);
            int id = responseHeader.getCallId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.channel.name + ": got response header " + TextFormat.shortDebugString((MessageOrBuilder)responseHeader) + ", totalSize: " + totalSize + " bytes"));
            }
            if ((call = this.channel.calls.get(id)) == null) {
                int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited((Message[])new Message[]{responseHeader});
                int whatIsLeftToRead = totalSize - readSoFar;
                LOG.debug((Object)("Unknown callId: " + id + ", skipping over this response of " + whatIsLeftToRead + " bytes"));
                in.skipBytes(whatIsLeftToRead);
            }
            if (responseHeader.hasException()) {
                RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                RemoteException re = this.createRemoteException(exceptionResponse);
                if (exceptionResponse.getExceptionClassName().equals(FatalConnectionException.class.getName())) {
                    this.channel.close((Throwable)re);
                } else if (call != null) {
                    call.setFailed((IOException)re);
                }
            } else {
                Message value = null;
                if (call != null && call.responseDefaultType != null) {
                    Message.Builder builder = call.responseDefaultType.newBuilderForType();
                    builder.mergeDelimitedFrom((InputStream)in);
                    value = builder.build();
                }
                CellScanner cellBlockScanner = null;
                if (responseHeader.hasCellBlockMeta()) {
                    int size = responseHeader.getCellBlockMeta().getLength();
                    byte[] cellBlock = new byte[size];
                    inBuffer.readBytes(cellBlock, 0, cellBlock.length);
                    cellBlockScanner = this.channel.client.createCellScanner(cellBlock);
                }
                if (call != null) {
                    call.setSuccess(value, cellBlockScanner);
                }
            }
            if (call != null) {
                this.channel.calls.remove(id);
            }
        }
        catch (IOException e) {
            this.channel.close(e);
        }
        finally {
            if (this.channel.rpcTimeout > 0) {
                this.channel.cleanupTimedOutCalls(this.channel.rpcTimeout);
            }
        }
    }

    private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }
}

