/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.LinkedList;
import mousio.hbase.async.HBaseClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncClientSmallScanner;
import org.apache.hadoop.hbase.client.AsyncRegionServerCallable;
import org.apache.hadoop.hbase.client.AsyncReversedClientScanner;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncClientSmallReversedScanner
extends AsyncReversedClientScanner {
    private static final Log LOG = LogFactory.getLog(AsyncClientSmallReversedScanner.class);
    private AsyncRegionServerCallable<Result[]> smallScanCallable = null;
    private byte[] skipRowOfFirstResult = null;

    public AsyncClientSmallReversedScanner(HBaseClient client, Scan scan, TableName tableName) {
        super(client, scan, tableName);
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        this.skipRowOfFirstResult = null;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals((byte[])startKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                this.setScanDone();
                return false;
            }
            localStartKey = this.createClosestRowBefore(startKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            localStartKey = this.lastResult.getRow();
            this.skipRowOfFirstResult = this.lastResult.getRow();
            ++cacheNum;
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = AsyncClientSmallScanner.getSmallScanCallable(this.scan, this.client, this.getTable(), localStartKey, cacheNum);
        if (this.scanMetrics != null && this.skipRowOfFirstResult == null) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @Override
    public <H extends ResponseHandler<Result[]>> H nextBatch(H handler) {
        try {
            this.nextScanner(this.caching, true, false);
        }
        catch (IOException e) {
            handler.onFailure(e);
            return handler;
        }
        this.caller.callWithRetries(this.smallScanCallable, new RetryingResponseHandler(handler, this.maxScannerResultSize, this.caching));
        return handler;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    private class RetryingResponseHandler
    implements ResponseHandler<Result[]> {
        private final ResponseHandler<Result[]> handler;
        private long remainingResultSize;
        private int countdown;
        boolean currentRegionDone = false;
        protected final LinkedList<Result> cache = new LinkedList();

        public RetryingResponseHandler(ResponseHandler<Result[]> handler, long maxScannerResultSize, int caching) {
            this.handler = handler;
            this.remainingResultSize = maxScannerResultSize;
            this.countdown = caching;
        }

        @Override
        public void onSuccess(Result[] values) {
            AsyncClientSmallReversedScanner.this.currentRegion = AsyncClientSmallReversedScanner.this.smallScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (AsyncClientSmallReversedScanner.this.scanMetrics != null) {
                AsyncClientSmallReversedScanner.this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - AsyncClientSmallReversedScanner.this.lastNext);
            }
            AsyncClientSmallReversedScanner.this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    if (i == 0 && AsyncClientSmallReversedScanner.this.skipRowOfFirstResult != null && Bytes.equals((byte[])AsyncClientSmallReversedScanner.this.skipRowOfFirstResult, (byte[])rs.getRow())) continue;
                    this.cache.add(rs);
                    --this.remainingResultSize;
                    --this.countdown;
                    AsyncClientSmallReversedScanner.this.lastResult = rs;
                }
            }
            this.currentRegionDone = this.countdown > 0;
            this.tryAgain(values);
        }

        private void tryAgain(Result[] values) {
            try {
                if (this.remainingResultSize > 0L && this.countdown > 0 && AsyncClientSmallReversedScanner.this.nextScanner(this.countdown, values == null, this.currentRegionDone)) {
                    AsyncClientSmallReversedScanner.this.caller.callWithRetries(AsyncClientSmallReversedScanner.this.callable, this);
                } else {
                    if (this.remainingResultSize == 0L) {
                        AsyncClientSmallReversedScanner.this.setScanDone();
                    }
                    this.handler.onSuccess(this.cache.toArray(new Result[this.cache.size()]));
                    this.cache.clear();
                    AsyncClientSmallReversedScanner.this.writeScanMetrics();
                }
            }
            catch (IOException e) {
                this.handler.onFailure(e);
            }
        }

        @Override
        public void onFailure(IOException e) {
            this.handler.onFailure(e);
        }
    }
}

