/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.LinkedList;
import mousio.hbase.async.HBaseClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncClientScanner;
import org.apache.hadoop.hbase.client.AsyncRegionServerCallable;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncClientSmallScanner
extends AsyncClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private AsyncRegionServerCallable<Result[]> smallScanCallable = null;
    private byte[] skipRowOfFirstResult = null;

    public AsyncClientSmallScanner(HBaseClient client, Scan scan, TableName tableName) {
        super(client, scan, tableName);
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        this.skipRowOfFirstResult = null;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                this.setScanDone();
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            localStartKey = this.lastResult.getRow();
            this.skipRowOfFirstResult = this.lastResult.getRow();
            ++cacheNum;
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = AsyncClientSmallScanner.getSmallScanCallable(this.scan, this.client, this.getTable(), localStartKey, cacheNum);
        if (this.scanMetrics != null && this.skipRowOfFirstResult == null) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    static AsyncRegionServerCallable<Result[]> getSmallScanCallable(final Scan scan, HBaseClient client, TableName table, byte[] localStartKey, final int cacheNum) throws IOException {
        scan.setStartRow(localStartKey);
        return new AsyncRegionServerCallable<Result[]>(client, table, scan.getStartRow()){

            @Override
            public void call(final ResponseHandler<Result[]> handler) {
                ClientProtos.ScanRequest request;
                try {
                    request = RequestConverter.buildScanRequest((byte[])this.getLocation().getRegionInfo().getRegionName(), (Scan)scan, (int)cacheNum, (boolean)true);
                }
                catch (IOException e) {
                    handler.onFailure(e);
                    return;
                }
                final AsyncPayloadCarryingRpcController controller = new AsyncPayloadCarryingRpcController();
                controller.setPriority(this.getTableName());
                controller.notifyOnFail(new RpcCallback<IOException>(){

                    public void run(IOException error) {
                        handler.onFailure(error);
                    }
                });
                this.getStub().scan((RpcController)controller, request, (RpcCallback)new RpcCallback<ClientProtos.ScanResponse>(){

                    public void run(ClientProtos.ScanResponse response) {
                        try {
                            handler.onSuccess(ResponseConverter.getResults((CellScanner)controller.cellScanner(), (ClientProtos.ScanResponse)response));
                        }
                        catch (IOException e) {
                            handler.onFailure(e);
                        }
                    }
                });
            }
        };
    }

    @Override
    public <H extends ResponseHandler<Result[]>> H nextBatch(H handler) {
        try {
            this.nextScanner(this.caching, true, false);
        }
        catch (IOException e) {
            handler.onFailure(e);
            return handler;
        }
        this.caller.callWithRetries(this.smallScanCallable, new RetryingResponseHandler(handler, this.maxScannerResultSize, this.caching));
        return handler;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    private class RetryingResponseHandler
    implements ResponseHandler<Result[]> {
        private final ResponseHandler<Result[]> handler;
        private long remainingResultSize;
        private int countdown;
        boolean currentRegionDone = false;
        protected final LinkedList<Result> cache = new LinkedList();

        public RetryingResponseHandler(ResponseHandler<Result[]> handler, long maxScannerResultSize, int caching) {
            this.handler = handler;
            this.remainingResultSize = maxScannerResultSize;
            this.countdown = caching;
        }

        @Override
        public void onSuccess(Result[] values) {
            AsyncClientSmallScanner.this.currentRegion = AsyncClientSmallScanner.this.smallScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (AsyncClientSmallScanner.this.scanMetrics != null) {
                AsyncClientSmallScanner.this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - AsyncClientSmallScanner.this.lastNext);
            }
            AsyncClientSmallScanner.this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    if (i == 0 && AsyncClientSmallScanner.this.skipRowOfFirstResult != null && Bytes.equals((byte[])AsyncClientSmallScanner.this.skipRowOfFirstResult, (byte[])rs.getRow())) continue;
                    this.cache.add(rs);
                    --this.remainingResultSize;
                    --this.countdown;
                    AsyncClientSmallScanner.this.lastResult = rs;
                }
            }
            this.currentRegionDone = this.countdown > 0;
            this.tryAgain(values);
        }

        private void tryAgain(Result[] values) {
            try {
                if (this.remainingResultSize > 0L && this.countdown > 0 && AsyncClientSmallScanner.this.nextScanner(this.countdown, values == null, this.currentRegionDone)) {
                    AsyncClientSmallScanner.this.caller.callWithRetries(AsyncClientSmallScanner.this.callable, this);
                } else {
                    if (this.remainingResultSize <= 0L) {
                        AsyncClientSmallScanner.this.setScanDone();
                    }
                    this.handler.onSuccess(this.cache.toArray(new Result[this.cache.size()]));
                    this.cache.clear();
                    AsyncClientSmallScanner.this.writeScanMetrics();
                }
            }
            catch (IOException e) {
                this.handler.onFailure(e);
            }
        }

        @Override
        public void onFailure(IOException e) {
            this.handler.onFailure(e);
        }
    }
}

