/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import mousio.hbase.async.HBaseClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncClientScanner;
import org.apache.hadoop.hbase.client.AsyncReversedScannerCallable;
import org.apache.hadoop.hbase.client.AsyncScannerCallable;
import org.apache.hadoop.hbase.client.ResponseHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ExceptionUtil;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AsyncReversedClientScanner
extends AsyncClientScanner {
    private static final Log LOG = LogFactory.getLog(ReversedClientScanner.class);
    static byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray((int)9);

    public AsyncReversedClientScanner(HBaseClient client, Scan scan, TableName tableName) {
        super(client, scan, tableName);
    }

    @Override
    protected void nextScanner(int nbRows, boolean done, final ResponseHandler<Boolean> handler) {
        byte[] localStartKey;
        if (this.checkToCloseScanner(nbRows, done, handler)) {
            return;
        }
        boolean locateTheClosestFrontRow = true;
        if (this.currentRegion != null) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals((byte[])startKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished " + this.currentRegion));
                }
                this.setScanDone();
                handler.onSuccess(false);
                return;
            }
            localStartKey = startKey;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
            if (!Bytes.equals((byte[])localStartKey, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                locateTheClosestFrontRow = false;
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        byte[] locateStartRow = locateTheClosestFrontRow ? this.createClosestRowBefore(localStartKey) : null;
        this.callable = this.getScannerCallable(localStartKey, nbRows, locateStartRow);
        this.caller.callWithRetries(this.callable, new ResponseHandler<Result[]>(){

            @Override
            public void onSuccess(Result[] response) {
                AsyncReversedClientScanner.this.currentRegion = AsyncReversedClientScanner.this.callable.getHRegionInfo();
                if (AsyncReversedClientScanner.this.scanMetrics != null) {
                    AsyncReversedClientScanner.this.scanMetrics.countOfRegions.incrementAndGet();
                }
                handler.onSuccess(true);
            }

            @Override
            public void onFailure(IOException e) {
                try {
                    ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                }
                catch (InterruptedIOException e1) {
                    handler.onFailure(e1);
                    return;
                }
                AsyncReversedClientScanner.this.close();
                handler.onFailure(e);
            }
        });
    }

    protected AsyncScannerCallable getScannerCallable(byte[] localStartKey, int nbRows, byte[] locateStartRow) {
        this.scan.setStartRow(localStartKey);
        AsyncReversedScannerCallable s = new AsyncReversedScannerCallable(this.client, this.getTable(), this.scan, this.scanMetrics, locateStartRow, new AsyncPayloadCarryingRpcController());
        s.setMaxResults(nbRows);
        return s;
    }

    @Override
    protected boolean checkScanStopRow(byte[] startKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo((byte[])(stopRow = this.scan.getStopRow()), (int)0, (int)stopRow.length, (byte[])startKey, (int)0, (int)startKey.length)) >= 0;
    }

    protected byte[] createClosestRowBefore(byte[] row) {
        if (row == null) {
            throw new IllegalArgumentException("The passed row is empty");
        }
        if (Bytes.equals((byte[])row, (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] closestFrontRow = Arrays.copyOf(row, row.length);
        closestFrontRow[row.length - 1] = (byte)((closestFrontRow[row.length - 1] & 0xFF) - 1);
        closestFrontRow = Bytes.add((byte[])closestFrontRow, (byte[])MAX_BYTE_ARRAY);
        return closestFrontRow;
    }
}

