/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.List;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.TimeLimitedRpcController;

@InterfaceAudience.Private
public class AsyncPayloadCarryingRpcController
extends TimeLimitedRpcController
implements CellScannable {
    private int priority = 0;
    private CellScanner cellScanner;

    public AsyncPayloadCarryingRpcController() {
        this((CellScanner)null);
    }

    public AsyncPayloadCarryingRpcController(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    public AsyncPayloadCarryingRpcController(List<CellScannable> cellIterables) {
        this.cellScanner = cellIterables == null ? null : CellUtil.createCellScanner(cellIterables);
    }

    public CellScanner cellScanner() {
        return this.cellScanner;
    }

    public void setCellScanner(CellScanner cellScanner) {
        this.cellScanner = cellScanner;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPriority(TableName tn) {
        this.priority = tn != null && tn.isSystemTable() ? 100 : 0;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void reset() {
        super.reset();
        this.priority = 0;
        this.cellScanner = null;
    }
}

