/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AsyncCall;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.AsyncServerResponseHandler;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.SaslClientHandler;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class AsyncRpcChannel {
    public static final Log LOG = LogFactory.getLog((String)AsyncRpcChannel.class.getName());
    private static final int MAX_SASL_RETRIES = 5;
    protected static final Map<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>>();
    final AsyncRpcClient client;
    private final RpcClient.ConnectionId connectionId;
    private Channel channel;
    String name;
    final User ticket;
    final String serviceName;
    final InetSocketAddress address;
    ConcurrentSkipListMap<Integer, AsyncCall> calls = new ConcurrentSkipListMap();
    private int ioFailureCounter = 0;
    private int connectFailureCounter = 0;
    boolean useSasl;
    AuthMethod authMethod;
    private int reloginMaxBackoff;
    private Token<? extends TokenIdentifier> token;
    private String serverPrincipal;
    boolean shouldCloseConnection = false;
    private IOException closeException;
    private Timeout cleanupTimer;
    private final TimerTask timeoutTask = new TimerTask(){

        public void run(Timeout timeout) throws Exception {
            AsyncRpcChannel.this.cleanupTimer = null;
            AsyncRpcChannel.this.cleanupCalls(false);
        }
    };

    public AsyncRpcChannel(Bootstrap bootstrap, AsyncRpcClient client, RpcClient.ConnectionId connectionId) {
        this.client = client;
        this.ticket = connectionId.getTicket();
        this.serviceName = connectionId.getServiceName();
        this.address = connectionId.getAddress();
        this.connectionId = connectionId;
        this.channel = this.connect(bootstrap).channel();
        this.name = "IPC Client (" + this.channel.hashCode() + ") connection to " + this.address.toString() + (this.ticket == null ? " from an unknown user" : " from " + this.ticket.getName());
    }

    private ChannelFuture connect(final Bootstrap bootstrap) {
        return bootstrap.remoteAddress((SocketAddress)this.address).connect().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (f.cause() instanceof SocketException) {
                        AsyncRpcChannel.this.retryOrClose(bootstrap, AsyncRpcChannel.this.connectFailureCounter++, f.cause());
                    } else {
                        AsyncRpcChannel.this.retryOrClose(bootstrap, AsyncRpcChannel.this.ioFailureCounter++, f.cause());
                    }
                    return;
                }
                AsyncRpcChannel.this.channel = f.channel();
                AsyncRpcChannel.this.setupAuthorization();
                ByteBuf b = AsyncRpcChannel.this.channel.alloc().directBuffer(6);
                AsyncRpcChannel.this.createPreamble(b, AsyncRpcChannel.this.authMethod);
                AsyncRpcChannel.this.channel.writeAndFlush((Object)b).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                if (AsyncRpcChannel.this.useSasl) {
                    UserGroupInformation ticket = AsyncRpcChannel.this.ticket.getUGI();
                    if (AsyncRpcChannel.this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                        ticket = ticket.getRealUser();
                    }
                    if (ticket == null) {
                        throw new FatalConnectionException("ticket/user is null");
                    }
                    SaslClientHandler saslHandler = (SaslClientHandler)((Object)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslClientHandler>(){

                        @Override
                        public SaslClientHandler run() throws IOException {
                            return AsyncRpcChannel.this.getSaslHandler(bootstrap);
                        }
                    }));
                    if (saslHandler != null) {
                        AsyncRpcChannel.this.channel.pipeline().addFirst(new ChannelHandler[]{saslHandler});
                    } else {
                        AsyncRpcChannel.this.authMethod = AuthMethod.SIMPLE;
                        AsyncRpcChannel.this.useSasl = false;
                    }
                } else {
                    AsyncRpcChannel.this.startHBaseConnection(f.channel());
                }
            }
        });
    }

    private void startHBaseConnection(Channel ch) {
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
        ch.pipeline().addLast(new ChannelHandler[]{new AsyncServerResponseHandler(this)});
        try {
            this.writeChannelHeader(ch).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        AsyncRpcChannel.this.close(future.cause());
                        return;
                    }
                    for (AsyncCall call : AsyncRpcChannel.this.calls.values()) {
                        AsyncRpcChannel.this.writeRequest(call);
                    }
                }
            });
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    private SaslClientHandler getSaslHandler(final Bootstrap bootstrap) throws IOException {
        return new SaslClientHandler(this.authMethod, this.token, this.serverPrincipal, this.client.fallbackAllowed, this.client.conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()), new SaslClientHandler.SaslExceptionHandler(){

            @Override
            public void handle(int retryCount, Random random, Throwable cause) {
                try {
                    AsyncRpcChannel.this.handleSaslConnectionFailure(retryCount, cause, AsyncRpcChannel.this.ticket.getUGI());
                    AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) throws Exception {
                            AsyncRpcChannel.this.connect(bootstrap);
                        }
                    }, (long)(random.nextInt(AsyncRpcChannel.this.reloginMaxBackoff) + 1), TimeUnit.MILLISECONDS);
                }
                catch (IOException | InterruptedException e) {
                    AsyncRpcChannel.this.close(e);
                }
            }
        }, new SaslClientHandler.SaslSuccessfulConnectHandler(){

            @Override
            public void onSuccess(Channel channel) {
                AsyncRpcChannel.this.startHBaseConnection(channel);
            }
        });
    }

    private void retryOrClose(final Bootstrap bootstrap, int connectCounter, Throwable e) {
        if (connectCounter < this.client.maxRetries) {
            AsyncRpcClient.WHEEL_TIMER.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    AsyncRpcChannel.this.connect(bootstrap);
                }
            }, this.client.failureSleep, TimeUnit.MILLISECONDS);
        } else {
            this.client.failedServers.addToFailedServers(this.address);
            this.close(e);
        }
    }

    public Promise<Message> callMethod(Descriptors.MethodDescriptor method, AsyncPayloadCarryingRpcController controller, Message request, Message responsePrototype) {
        if (this.shouldCloseConnection) {
            Promise promise = this.channel.eventLoop().newPromise();
            promise.setFailure((Throwable)new ConnectException());
            return promise;
        }
        final AsyncCall call = new AsyncCall(this.channel.eventLoop(), this.client.callIdCnt.getAndIncrement(), method, request, controller, responsePrototype);
        controller.notifyOnCancel(new RpcCallback<Object>(){

            public void run(Object parameter) {
                AsyncRpcChannel.this.failCall(call, new IOException("Canceled connection"));
            }
        });
        this.calls.put(call.id, call);
        if (this.cleanupTimer == null) {
            this.cleanupTimer = AsyncRpcClient.WHEEL_TIMER.newTimeout(this.timeoutTask, call.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.channel.isActive()) {
            this.writeRequest(call);
        }
        return call;
    }

    public Promise<Message> callMethodWithPromise(Descriptors.MethodDescriptor method, AsyncPayloadCarryingRpcController controller, Message request, Message responsePrototype) throws ConnectException {
        if (this.shouldCloseConnection || !this.channel.isOpen()) {
            throw new ConnectException();
        }
        return this.callMethod(method, controller, request, responsePrototype);
    }

    private ChannelFuture writeChannelHeader(Channel channel) throws IOException {
        RPCProtos.ConnectionHeader.Builder headerBuilder = RPCProtos.ConnectionHeader.newBuilder().setServiceName(this.serviceName);
        RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
        builder.setServiceName(this.serviceName);
        RPCProtos.UserInformation userInfoPB = this.buildUserInfo(this.ticket.getUGI(), this.authMethod);
        if (userInfoPB != null) {
            headerBuilder.setUserInfo(userInfoPB);
        }
        if (this.client.codec != null) {
            headerBuilder.setCellBlockCodecClass(this.client.codec.getClass().getCanonicalName());
        }
        if (this.client.compressor != null) {
            headerBuilder.setCellBlockCompressorClass(this.client.compressor.getClass().getCanonicalName());
        }
        RPCProtos.ConnectionHeader header = headerBuilder.build();
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited((Message[])new Message[]{header});
        ByteBuf b = channel.alloc().directBuffer(totalSize);
        b.writeInt(header.getSerializedSize());
        b.writeBytes(header.toByteArray());
        return channel.writeAndFlush((Object)b);
    }

    private void writeRequest(AsyncCall call) {
        block20: {
            try {
                ByteBuffer cellBlock;
                if (this.shouldCloseConnection) {
                    return;
                }
                RPCProtos.RequestHeader.Builder requestHeaderBuilder = RPCProtos.RequestHeader.newBuilder();
                requestHeaderBuilder.setCallId(call.id).setMethodName(call.method.getName()).setRequestParam(call.param != null);
                if (Trace.isTracing()) {
                    Span s = Trace.currentSpan();
                    requestHeaderBuilder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(s.getSpanId()).setTraceId(s.getTraceId()));
                }
                if ((cellBlock = this.client.buildCellBlock(call.controller.cellScanner())) != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(cellBlock.limit());
                    requestHeaderBuilder.setCellBlockMeta(cellBlockBuilder.build());
                }
                if (call.controller.getPriority() != 0) {
                    requestHeaderBuilder.setPriority(call.controller.getPriority());
                }
                RPCProtos.RequestHeader rh = requestHeaderBuilder.build();
                int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited((Message[])new Message[]{rh, call.param});
                if (cellBlock != null) {
                    totalSize += cellBlock.remaining();
                }
                ByteBuf b = this.channel.alloc().directBuffer(totalSize);
                try (ByteBufOutputStream out = new ByteBufOutputStream(b);){
                    IPCUtil.write((OutputStream)out, (Message)rh, (Message)call.param, (ByteBuffer)cellBlock);
                }
                this.channel.writeAndFlush((Object)b).addListener((GenericFutureListener)new CallWriteListener(this, call));
            }
            catch (IOException e) {
                if (this.shouldCloseConnection) break block20;
                this.close(e);
            }
        }
    }

    void failCall(AsyncCall call, IOException cause) {
        this.calls.remove(call.id);
        call.setFailed(cause);
    }

    private void setupAuthorization() throws IOException {
        SecurityInfo securityInfo = SecurityInfo.getInfo((String)this.serviceName);
        this.useSasl = this.client.userProvider.isHBaseSecurityEnabled();
        this.token = null;
        if (this.useSasl && securityInfo != null) {
            String serverKey;
            AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
            if (tokenKind != null) {
                TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenKind);
                if (tokenSelector != null) {
                    this.token = tokenSelector.selectToken(new Text(this.client.clusterId), this.ticket.getUGI().getTokens());
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No token selector found for type " + tokenKind));
                }
            }
            if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
            }
            this.serverPrincipal = SecurityUtil.getServerPrincipal((String)this.client.conf.get(serverKey), (String)this.address.getAddress().getCanonicalHostName().toLowerCase());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RPC Server Kerberos principal name for service=" + this.serviceName + " is " + this.serverPrincipal));
            }
        }
        this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Use " + this.authMethod + " authentication for service " + this.serviceName + ", sasl=" + this.useSasl));
        }
        this.reloginMaxBackoff = this.client.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
    }

    private RPCProtos.UserInformation buildUserInfo(UserGroupInformation ugi, AuthMethod authMethod) {
        if (ugi == null || authMethod == AuthMethod.DIGEST) {
            return null;
        }
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        if (authMethod == AuthMethod.KERBEROS) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
        } else if (authMethod == AuthMethod.SIMPLE) {
            userInfoPB.setEffectiveUser(ugi.getUserName());
            if (ugi.getRealUser() != null) {
                userInfoPB.setRealUser(ugi.getRealUser().getUserName());
            }
        }
        return userInfoPB.build();
    }

    private void createPreamble(ByteBuf byteBuf, AuthMethod authMethod) {
        byteBuf.writeBytes(HConstants.RPC_HEADER.array());
        byteBuf.writeByte(0);
        byteBuf.writeByte((int)authMethod.code);
    }

    public void close(final Throwable e) {
        this.client.removeConnection(this.connectionId);
        this.channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (AsyncRpcChannel.this.shouldCloseConnection) {
                    return;
                }
                AsyncRpcChannel.this.shouldCloseConnection = true;
                if (e != null) {
                    if (e instanceof IOException) {
                        AsyncRpcChannel.this.closeException = (IOException)e;
                    } else {
                        AsyncRpcChannel.this.closeException = new IOException(e);
                    }
                }
                if (LOG.isDebugEnabled() && AsyncRpcChannel.this.closeException != null) {
                    LOG.debug((Object)(AsyncRpcChannel.this.name + ": closing ipc connection to " + AsyncRpcChannel.this.address + ": " + AsyncRpcChannel.this.closeException.getMessage()));
                }
                AsyncRpcChannel.this.cleanupCalls(true);
                AsyncRpcChannel.this.channel.disconnect().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(AsyncRpcChannel.this.name + ": closed"));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCalls(boolean cleanAll) {
        if (this.cleanupTimer != null) {
            this.cleanupTimer.cancel();
            this.cleanupTimer = null;
        }
        if (cleanAll) {
            Iterator<AsyncCall> i$ = this.calls.values().iterator();
            while (i$.hasNext()) {
                AsyncCall call;
                AsyncCall asyncCall = call = i$.next();
                synchronized (asyncCall) {
                    if (!call.isDone()) {
                        if (this.closeException == null) {
                            this.failCall(call, new IOException("Call id=" + call.id + " on server " + this.address + " aborted: connection is closing"));
                        } else {
                            this.failCall(call, this.closeException);
                        }
                    }
                }
            }
        } else {
            for (AsyncCall call : this.calls.values()) {
                long waitTime = EnvironmentEdgeManager.currentTimeMillis() - call.getStartTime();
                long timeout = call.getRpcTimeout();
                if (timeout <= 0L || waitTime < timeout) break;
                AsyncCall asyncCall = call;
                synchronized (asyncCall) {
                    if (!call.isDone()) {
                        this.closeException = new RpcClient.CallTimeoutException("Call id=" + call.id + ", waitTime=" + waitTime + ", rpcTimeout=" + timeout);
                        this.failCall(call, this.closeException);
                    }
                }
            }
            if (!this.calls.isEmpty()) {
                AsyncCall firstCall = this.calls.firstEntry().getValue();
                long maxWaitTime = EnvironmentEdgeManager.currentTimeMillis() - firstCall.getStartTime();
                long newTimeout = maxWaitTime < firstCall.getRpcTimeout() ? firstCall.getRpcTimeout() - maxWaitTime : 0L;
                this.closeException = null;
                this.cleanupTimer = AsyncRpcClient.WHEEL_TIMER.newTimeout(this.timeoutTask, newTimeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    public boolean isAlive() {
        return this.channel.isOpen();
    }

    private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUser = currentUser.getRealUser();
        return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
    }

    private void handleSaslConnectionFailure(final int currRetries, final Throwable ex, UserGroupInformation user) throws IOException, InterruptedException {
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                if (AsyncRpcChannel.this.shouldAuthenticateOverKrb()) {
                    if (currRetries < 5) {
                        LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                        if (UserGroupInformation.isLoginKeytabBased()) {
                            UserGroupInformation.getLoginUser().reloginFromKeytab();
                        } else {
                            UserGroupInformation.getLoginUser().reloginFromTicketCache();
                        }
                        return null;
                    }
                    String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + AsyncRpcChannel.this.serverPrincipal;
                    LOG.warn((Object)msg);
                    throw (IOException)new IOException(msg).initCause(ex);
                }
                LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                if (ex instanceof RemoteException) {
                    throw (RemoteException)ex;
                }
                if (ex instanceof SaslException) {
                    String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                    LOG.fatal((Object)msg, ex);
                    throw new RuntimeException(msg, ex);
                }
                throw new IOException(ex);
            }
        });
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    static {
        tokenHandlers.put(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, (TokenSelector<? extends TokenIdentifier>)new AuthenticationTokenSelector());
    }

    private static final class CallWriteListener
    implements ChannelFutureListener {
        private final AsyncRpcChannel rpcChannel;
        private final AsyncCall call;

        public CallWriteListener(AsyncRpcChannel asyncRpcChannel, AsyncCall call) {
            this.rpcChannel = asyncRpcChannel;
            this.call = call;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess() && !this.call.isDone()) {
                if (future.cause() instanceof IOException) {
                    this.rpcChannel.failCall(this.call, (IOException)future.cause());
                } else {
                    this.rpcChannel.failCall(this.call, new IOException(future.cause()));
                }
            }
        }
    }
}

