/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.AsyncPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.AsyncRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class AsyncRpcClient
extends AbstractRpcClient {
    public static final HashedWheelTimer WHEEL_TIMER = new HashedWheelTimer(100L, TimeUnit.MILLISECONDS);
    private static final ChannelInitializer<SocketChannel> DEFAULT_CHANNEL_INITIALIZER = new ChannelInitializer<SocketChannel>(){

        protected void initChannel(SocketChannel ch) throws Exception {
        }
    };
    protected final AtomicInteger callIdCnt = new AtomicInteger();
    private final NioEventLoopGroup eventLoopGroup;
    private final PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> connections;
    final RpcClient.FailedServers failedServers;
    private final Bootstrap bootstrap;

    @VisibleForTesting
    AsyncRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, ChannelInitializer<SocketChannel> channelInitializer) {
        super(configuration, clusterId, localAddress);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Starting async Hbase RPC client");
        }
        int maxThreads = this.conf.getInt("hbase.rpc.client.threads.max", 0);
        this.eventLoopGroup = new NioEventLoopGroup(maxThreads, Threads.newDaemonThreadFactory((String)"AsyncRpcChannel"));
        this.connections = new PoolMap(AsyncRpcClient.getPoolType(configuration), AsyncRpcClient.getPoolSize(configuration));
        this.failedServers = new RpcClient.FailedServers(configuration);
        int operationTimeout = configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay)).option(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)operationTimeout);
        if (channelInitializer == null) {
            channelInitializer = DEFAULT_CHANNEL_INITIALIZER;
        }
        this.bootstrap.handler(channelInitializer);
        if (localAddress != null) {
            this.bootstrap.localAddress(localAddress);
        }
    }

    public AsyncRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress) {
        this(configuration, clusterId, localAddress, null);
    }

    @Override
    protected Pair<Message, CellScanner> call(AsyncPayloadCarryingRpcController pcrc, Descriptors.MethodDescriptor md, Message param, Message returnType, User ticket, InetSocketAddress addr) throws IOException, InterruptedException {
        AsyncRpcChannel connection = this.createRpcChannel(md.getService().getName(), addr, ticket);
        Promise<Message> promise = connection.callMethodWithPromise(md, pcrc, param, returnType);
        try {
            Message response = (Message)promise.get();
            return new Pair((Object)response, (Object)pcrc.cellScanner());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    private void callMethod(Descriptors.MethodDescriptor md, final AsyncPayloadCarryingRpcController pcrc, Message param, Message returnType, User ticket, InetSocketAddress addr, final RpcCallback<Message> done) {
        try {
            AsyncRpcChannel connection = this.createRpcChannel(md.getService().getName(), addr, ticket);
            connection.callMethod(md, pcrc, param, returnType).addListener((GenericFutureListener)new GenericFutureListener<Future<Message>>(){

                public void operationComplete(Future<Message> future) throws Exception {
                    if (!future.isSuccess()) {
                        Throwable cause = future.cause();
                        if (cause instanceof IOException) {
                            pcrc.setFailed((IOException)cause);
                        } else {
                            pcrc.setFailed(new IOException(cause));
                        }
                    } else {
                        try {
                            done.run(future.get());
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof IOException) {
                                pcrc.setFailed((IOException)cause);
                            } else {
                                pcrc.setFailed(new IOException(cause));
                            }
                        }
                        catch (InterruptedException e) {
                            pcrc.setFailed(new IOException(e));
                        }
                    }
                }
            });
        }
        catch (RpcClient.FailedServerException | StoppedRpcClientException e) {
            pcrc.setFailed((IOException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping async HBase RPC client");
        }
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            for (AsyncRpcChannel conn : this.connections.values()) {
                conn.close(null);
            }
        }
        this.eventLoopGroup.shutdownGracefully();
    }

    public CellScanner createCellScanner(byte[] cellBlock) throws IOException {
        return this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
    }

    public ByteBuffer buildCellBlock(CellScanner cells) throws IOException {
        return this.ipcUtil.buildCellBlock(this.codec, this.compressor, cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncRpcChannel createRpcChannel(String serviceName, InetSocketAddress location, User ticket) throws StoppedRpcClientException, RpcClient.FailedServerException {
        AsyncRpcChannel rpcChannel;
        if (this.eventLoopGroup.isShuttingDown() || this.eventLoopGroup.isShutdown()) {
            throw new StoppedRpcClientException();
        }
        if (this.failedServers.isFailedServer(location)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not trying to connect to " + location + " this server is in the failed servers list"));
            }
            throw new RpcClient.FailedServerException("This server is in the failed servers list: " + location);
        }
        RpcClient.ConnectionId id = new RpcClient.ConnectionId(ticket, serviceName, location, 0);
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            rpcChannel = (AsyncRpcChannel)this.connections.get((Object)id);
            if (rpcChannel == null) {
                rpcChannel = new AsyncRpcChannel(this.bootstrap, this, id);
                this.connections.put((Object)id, (Object)rpcChannel);
            }
        }
        return rpcChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnections(ServerName sn) {
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            for (AsyncRpcChannel rpcChannel : this.connections.values()) {
                if (!rpcChannel.isAlive() || rpcChannel.address.getPort() != sn.getPort() || !rpcChannel.address.getHostName().contentEquals(sn.getHostname())) continue;
                LOG.info((Object)("The server on " + sn.toString() + " is dead - stopping the connection " + rpcChannel.toString()));
                rpcChannel.close(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(RpcClient.ConnectionId connectionId) {
        PoolMap<RpcClient.ConnectionId, AsyncRpcChannel> poolMap = this.connections;
        synchronized (poolMap) {
            this.connections.remove((Object)connectionId);
        }
    }

    public RpcChannel createRpcChannel(ServerName sn, User user, int rpcTimeout) {
        return new RpcChannelImplementation(this, sn, user, rpcTimeout);
    }

    public EventExecutor getEventLoop() {
        return this.eventLoopGroup.next();
    }

    @VisibleForTesting
    public static class RpcChannelImplementation
    implements RpcChannel {
        private final InetSocketAddress isa;
        private final AsyncRpcClient rpcClient;
        private final User ticket;
        private final int channelOperationTimeout;

        protected RpcChannelImplementation(AsyncRpcClient rpcClient, ServerName sn, User ticket, int channelOperationTimeout) {
            this.isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
            this.rpcClient = rpcClient;
            this.ticket = ticket;
            this.channelOperationTimeout = channelOperationTimeout;
        }

        public void callMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType, RpcCallback<Message> done) {
            AsyncPayloadCarryingRpcController pcrc;
            if (controller != null) {
                pcrc = (AsyncPayloadCarryingRpcController)controller;
                if (!pcrc.hasCallTimeout()) {
                    pcrc.setCallTimeout(this.channelOperationTimeout);
                }
            } else {
                pcrc = new AsyncPayloadCarryingRpcController();
                pcrc.setCallTimeout(this.channelOperationTimeout);
            }
            this.rpcClient.callMethod(md, pcrc, param, returnType, this.ticket, this.isa, (RpcCallback<Message>)done);
        }
    }
}

