/*
 * Decompiled with CFR 0.152.
 */
package mousio.jetcd;

import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import mousio.jetcd.requests.EtcdKeyDeleteRequest;
import mousio.jetcd.requests.EtcdKeyGetRequest;
import mousio.jetcd.requests.EtcdKeyPostRequest;
import mousio.jetcd.requests.EtcdKeyPutRequest;
import mousio.jetcd.requests.EtcdKeyRequest;
import mousio.jetcd.requests.EtcdVersionRequest;
import mousio.jetcd.responses.EtcdException;
import mousio.jetcd.transport.EtcdClientImpl;
import mousio.jetcd.transport.EtcdNettyClient;

public class EtcdClient
implements Closeable {
    private final EtcdNettyClient client;

    public EtcdClient(URI ... baseUri) {
        this((SslContext)null, baseUri);
    }

    public EtcdClient(SslContext sslContext, URI ... baseUri) {
        if (baseUri.length == 0) {
            baseUri = new URI[]{URI.create("https://127.0.0.1:4001")};
        }
        this.client = new EtcdNettyClient(sslContext, baseUri);
    }

    public String getVersion() {
        try {
            return new EtcdVersionRequest(this.client).send().get();
        }
        catch (IOException | TimeoutException | EtcdException e) {
            return null;
        }
    }

    public EtcdKeyPutRequest put(String key, String value) {
        return new EtcdKeyPutRequest((EtcdClientImpl)this.client, key).value(value);
    }

    public EtcdKeyPutRequest putDir(String dir) {
        return new EtcdKeyPutRequest((EtcdClientImpl)this.client, dir).isDir();
    }

    public EtcdKeyPostRequest post(String key, String value) {
        return new EtcdKeyPostRequest((EtcdClientImpl)this.client, key).value(value);
    }

    public EtcdKeyRequest delete(String key) {
        return new EtcdKeyDeleteRequest((EtcdClientImpl)this.client, key);
    }

    public EtcdKeyDeleteRequest deleteDir(String dir) {
        return new EtcdKeyDeleteRequest((EtcdClientImpl)this.client, dir).dir();
    }

    public EtcdKeyGetRequest get(String key) {
        return new EtcdKeyGetRequest((EtcdClientImpl)this.client, key);
    }

    public EtcdKeyGetRequest getDir(String dir) {
        return new EtcdKeyGetRequest((EtcdClientImpl)this.client, dir).dir();
    }

    public EtcdKeyGetRequest getAll() {
        return new EtcdKeyGetRequest(this.client);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

