/*
 * Decompiled with CFR 0.152.
 */
package mousio.jetcd.requests;

import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mousio.jetcd.promises.EtcdResponsePromise;
import mousio.jetcd.transport.EtcdClientImpl;

public abstract class EtcdRequest<R> {
    protected final EtcdClientImpl clientImpl;
    protected final HttpMethod method;
    private EtcdResponsePromise<R> promise;
    private int timeout = -1;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;

    protected EtcdRequest(EtcdClientImpl clientImpl, HttpMethod method) {
        this.clientImpl = clientImpl;
        this.method = method;
    }

    public abstract EtcdResponsePromise<R> send() throws IOException;

    public HttpMethod getMethod() {
        return this.method;
    }

    public abstract String getUri();

    public Map<String, String> getRequestParams() {
        return null;
    }

    public void setPromise(EtcdResponsePromise<R> promise) {
        this.promise = promise;
    }

    public EtcdResponsePromise<R> getPromise() {
        return this.promise;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public EtcdRequest timeout(int timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }
}

