/*
 * Decompiled with CFR 0.152.
 */
package mousio.jetcd.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Promise;
import mousio.jetcd.requests.EtcdKeyRequest;
import mousio.jetcd.responses.EtcdKeysResponse;
import mousio.jetcd.responses.EtcdKeysResponseParser;
import mousio.jetcd.transport.EtcdNettyClient;

public class EtcdKeyResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private final Promise<EtcdKeysResponse> promise;
    private final EtcdNettyClient client;
    private final EtcdKeyRequest request;

    public EtcdKeyResponseHandler(EtcdNettyClient etcdNettyClient, EtcdKeyRequest etcdKeyRequest) {
        this.client = etcdNettyClient;
        this.request = etcdKeyRequest;
        this.promise = etcdKeyRequest.getPromise().getNettyPromise();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        if (!response.content().isReadable()) {
            if (response.status().equals((Object)HttpResponseStatus.OK)) {
                this.client.connect(this.request);
                return;
            }
            if (!response.status().equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) && !response.status().equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT)) {
                this.promise.setFailure((Throwable)new Exception(response.status().toString()));
                return;
            }
            if (!response.headers().contains("Location")) {
                this.promise.setFailure((Throwable)new Exception("Missing Location header on redirect"));
                return;
            }
            this.client.connect(this.request, response.headers().get("Location"));
        }
        try {
            this.promise.setSuccess((Object)EtcdKeysResponseParser.parse(response.content()));
            return;
        }
        catch (Exception e) {
            this.promise.setFailure((Throwable)e);
        }
    }
}

