/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.promises;

import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import mousio.client.ConnectionState;
import mousio.client.retry.ConnectionFailHandler;
import mousio.client.retry.RetryHandler;
import mousio.client.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsePromise<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResponsePromise.class);
    private final RetryPolicy retryPolicy;
    private final ConnectionState connectionState;
    private final RetryHandler retryHandler;
    protected Promise<T> promise;
    protected T response;
    protected Throwable exception;
    List<IsSimplePromiseResponseHandler<T>> handlers;
    private final GenericFutureListener<Promise<T>> promiseHandler;

    public ResponsePromise(RetryPolicy retryPolicy, ConnectionState connectionState, RetryHandler retryHandler) {
        this.connectionState = connectionState;
        this.retryHandler = retryHandler;
        this.retryPolicy = retryPolicy;
        this.promiseHandler = new GenericFutureListener<Promise<T>>(){

            public void operationComplete(Promise<T> future) throws Exception {
                ResponsePromise.this.handlePromise(future);
            }
        };
    }

    public void attachNettyPromise(Promise<T> promise) {
        promise.addListener(this.promiseHandler);
        if (this.promise != null) {
            this.promise.removeListener(this.promiseHandler);
            this.promise.cancel(true);
        }
        this.promise = promise;
    }

    public void addListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers == null) {
            this.handlers = Arrays.asList(listener);
        } else {
            this.handlers.add(listener);
        }
    }

    public void removeListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers != null) {
            this.handlers.remove(listener);
        }
    }

    protected void handlePromise(Promise<T> promise) {
        if (!promise.isSuccess()) {
            this.setException(promise.cause());
        } else {
            this.response = promise.getNow();
            if (this.handlers != null) {
                for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                    h.onResponse(this);
                }
            }
        }
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        if (this.handlers != null) {
            for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                h.onResponse(this);
            }
        }
    }

    public T get() throws Exception {
        if (!this.waitForPromiseSuccess()) {
            return this.get();
        }
        if (this.response != null) {
            return this.response;
        }
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof io.netty.handler.timeout.TimeoutException) {
            throw new TimeoutException();
        }
        throw new IOException(this.exception);
    }

    protected boolean waitForPromiseSuccess() throws IOException, TimeoutException {
        if (!this.promise.isDone()) {
            Promise<T> listeningPromise = this.promise;
            listeningPromise.awaitUninterruptibly();
            if (listeningPromise != this.promise) {
                return false;
            }
            this.handlePromise(this.promise);
        }
        return true;
    }

    public T getNow() {
        return this.response;
    }

    public Promise<T> getNettyPromise() {
        return this.promise;
    }

    public void handleRetry(Throwable cause) {
        if (this.retryPolicy.shouldRetry(this.connectionState)) {
            ++this.connectionState.retryCount;
            logger.info(String.format("Retry %s to send command", this.connectionState.retryCount));
            this.retryPolicy.retry(this.connectionState, this.retryHandler, new ConnectionFailHandler(){

                @Override
                public void catchException(IOException exception) {
                    ResponsePromise.this.handleRetry(exception);
                }
            });
        } else {
            this.getNettyPromise().setFailure(cause);
        }
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public static interface IsSimplePromiseResponseHandler<T> {
        public void onResponse(ResponsePromise<T> var1);
    }
}

