/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.requests;

import io.netty.handler.codec.http.HttpMethod;
import java.util.concurrent.TimeUnit;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.requests.EtcdKeyRequest;
import mousio.etcd4j.transport.EtcdClientImpl;

public class EtcdKeyGetRequest
extends EtcdKeyRequest {
    private boolean wait = false;

    public EtcdKeyGetRequest(EtcdClientImpl clientImpl, RetryPolicy retryHandler) {
        super(clientImpl, HttpMethod.GET, retryHandler);
    }

    public EtcdKeyGetRequest(EtcdClientImpl clientImpl, String key, RetryPolicy retryHandler) {
        super(clientImpl, HttpMethod.GET, retryHandler);
        this.setKey(key);
    }

    public EtcdKeyGetRequest waitForChange() {
        this.wait = true;
        this.requestParams.put("wait", "true");
        return this;
    }

    public EtcdKeyGetRequest waitForChange(int waitIndex) {
        this.waitForChange();
        this.requestParams.put("waitIndex", waitIndex + "");
        return this;
    }

    public EtcdKeyGetRequest sorted() {
        this.requestParams.put("sorted", "true");
        return this;
    }

    public EtcdKeyGetRequest dir() {
        this.requestParams.put("dir", "true");
        return this;
    }

    public EtcdKeyGetRequest recursive() {
        this.requestParams.put("recursive", "true");
        return this;
    }

    public boolean shouldBeWaiting() {
        return this.wait;
    }

    @Override
    public EtcdKeyGetRequest timeout(int timeout, TimeUnit unit) {
        super.timeout(timeout, unit);
        return this;
    }

    @Override
    public EtcdKeyGetRequest setRetryPolicy(RetryPolicy retryPolicy) {
        super.setRetryPolicy(retryPolicy);
        return this;
    }
}

