package mousio.etcd4j;

import io.netty.handler.timeout.TimeoutException;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;

/**
 * Created by jurmous on 05-01-15.
 */
public class Main {
  public static void main(String[] args)
      throws EtcdException, java.util.concurrent.TimeoutException, IOException {
    EtcdClient etcdClient = new EtcdClient(URI.create("http://127.0.0.1:4003"));

    String etcdKey = "test111";
    String etcdValue = "hey";
    

    EtcdResponsePromise<EtcdKeysResponse> putPromise = etcdClient.put(etcdKey, etcdValue)
        .timeout(10, TimeUnit.SECONDS).send();
    try {
      EtcdKeysResponse response = putPromise.get();
      String returnVal = response.node.value;
      System.out.println(String
          .format("Etcd putValue - key %s, value %s, return %s", etcdKey, etcdValue, returnVal));
    } catch (TimeoutException e) {
      // Handle timeout
      System.out.println(String
          .format("Etcd putValue timeout exception %s, key %s, value %s", e.getMessage(), etcdKey,
              etcdValue));
      throw e;
    } catch (Exception e) {
      System.out.println(String
          .format("Etcd putValue exception %s, key %s, value %s", e.getMessage(), etcdKey,
              etcdValue));
      throw e;
    }
  }
}
