/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.promises;

import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import mousio.client.ConnectionState;
import mousio.client.retry.ConnectionFailHandler;
import mousio.client.retry.RetryHandler;
import mousio.client.retry.RetryPolicy;

public class ResponsePromise<T> {
    private final RetryPolicy retryPolicy;
    private final ConnectionState connectionState;
    private final RetryHandler retryHandler;
    protected Promise<T> promise;
    protected T response;
    protected Throwable exception;
    private List<IsSimplePromiseResponseHandler<T>> handlers;
    private final GenericFutureListener<Promise<T>> promiseHandler;
    private final ConnectionFailHandler connectionFailHandler;

    public ResponsePromise(RetryPolicy retryPolicy, ConnectionState connectionState, RetryHandler retryHandler) {
        this.connectionState = connectionState;
        this.retryHandler = retryHandler;
        this.retryPolicy = retryPolicy;
        this.promiseHandler = new GenericFutureListener<Promise<T>>(){

            public void operationComplete(Promise<T> future) throws Exception {
                ResponsePromise.this.handlePromise(future);
            }
        };
        this.connectionFailHandler = new ConnectionFailHandler(){

            @Override
            public void catchException(IOException exception) {
                ResponsePromise.this.handleRetry(exception);
            }
        };
    }

    public void attachNettyPromise(Promise<T> promise) {
        promise.addListener(this.promiseHandler);
        Promise<T> oldPromise = this.promise;
        this.promise = promise;
        if (oldPromise != null) {
            oldPromise.removeListener(this.promiseHandler);
            oldPromise.cancel(true);
        }
    }

    public void addListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers == null) {
            this.handlers = new LinkedList<IsSimplePromiseResponseHandler<T>>();
        }
        this.handlers.add(listener);
        if (this.response != null || this.exception != null) {
            listener.onResponse(this);
        }
    }

    public void removeListener(IsSimplePromiseResponseHandler<T> listener) {
        if (this.handlers != null) {
            this.handlers.remove(listener);
        }
    }

    protected void handlePromise(Promise<T> promise) {
        if (!promise.isSuccess()) {
            this.setException(promise.cause());
        } else {
            this.response = promise.getNow();
            if (this.handlers != null) {
                for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                    h.onResponse(this);
                }
            }
        }
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        if (this.handlers != null) {
            for (IsSimplePromiseResponseHandler<T> h : this.handlers) {
                h.onResponse(this);
            }
        }
    }

    public T get() throws Exception {
        if (!this.waitForPromiseSuccess()) {
            return this.get();
        }
        if (this.response != null) {
            return this.response;
        }
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof io.netty.handler.timeout.TimeoutException) {
            throw new TimeoutException();
        }
        throw new IOException(this.exception);
    }

    protected boolean waitForPromiseSuccess() throws IOException, TimeoutException {
        if (!this.promise.isDone() && !this.promise.isCancelled()) {
            Promise<T> listeningPromise = this.promise;
            listeningPromise.awaitUninterruptibly();
            if (listeningPromise != this.promise) {
                return false;
            }
            this.handlePromise(this.promise);
        }
        return true;
    }

    public T getNow() {
        return this.response;
    }

    public Promise<T> getNettyPromise() {
        return this.promise;
    }

    public void handleRetry(Throwable cause) {
        try {
            this.retryPolicy.retry(this.connectionState, this.retryHandler, this.connectionFailHandler);
        }
        catch (RetryPolicy.RetryCancelled retryCancelled) {
            this.getNettyPromise().setFailure(cause);
        }
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public void cancel() {
        this.promise.cancel(true);
    }

    public void cancel(Throwable throwable) {
        this.promise.cancel(true);
        this.exception = throwable;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static interface IsSimplePromiseResponseHandler<T> {
        public void onResponse(ResponsePromise<T> var1);
    }
}

